/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CSR
extends AbstractSegment {
    public CSR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 427, new Object[]{this.getMessage()}, "Sponsor Study ID");
            this.add(EI.class, false, 1, 427, new Object[]{this.getMessage()}, "Alternate Study ID");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Institution Registering the Patient");
            this.add(CX.class, true, 1, 1913, new Object[]{this.getMessage()}, "Sponsor Patient ID");
            this.add(CX.class, false, 1, 1913, new Object[]{this.getMessage()}, "Alternate Patient ID - CSR");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Date/Time of Patient Study Registration");
            this.add(XCN.class, false, 0, 3220, new Object[]{this.getMessage()}, "Person Performing Study Registration");
            this.add(XCN.class, true, 0, 3220, new Object[]{this.getMessage()}, "Study Authorizing Provider");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Date/time Patient Study Consent Signed");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Patient Study Eligibility Status");
            this.add(DTM.class, false, 3, 24, new Object[]{this.getMessage()}, "Study Randomization Date/time");
            this.add(CWE.class, false, 3, 705, new Object[]{this.getMessage()}, "Randomized Study Arm");
            this.add(CWE.class, false, 3, 705, new Object[]{this.getMessage()}, "Stratum for Study Randomization");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Patient Evaluability Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Date/time Ended Study");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Reason Ended Study");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CSR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getSponsorStudyID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getCsr1_SponsorStudyID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getAlternateStudyID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getCsr2_AlternateStudyID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getInstitutionRegisteringThePatient() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getCsr3_InstitutionRegisteringThePatient() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CX getSponsorPatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getCsr4_SponsorPatientID() {
        CX retVal = (CX)this.getTypedField(4, 0);
        return retVal;
    }

    public CX getAlternatePatientIDCSR() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public CX getCsr5_AlternatePatientIDCSR() {
        CX retVal = (CX)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getDateTimeOfPatientStudyRegistration() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getCsr6_DateTimeOfPatientStudyRegistration() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public XCN[] getPersonPerformingStudyRegistration() {
        XCN[] retVal = (XCN[])this.getTypedField(7, new XCN[0]);
        return retVal;
    }

    public XCN[] getCsr7_PersonPerformingStudyRegistration() {
        XCN[] retVal = (XCN[])this.getTypedField(7, new XCN[0]);
        return retVal;
    }

    public int getPersonPerformingStudyRegistrationReps() {
        return this.getReps(7);
    }

    public XCN getPersonPerformingStudyRegistration(int rep) {
        XCN retVal = (XCN)this.getTypedField(7, rep);
        return retVal;
    }

    public XCN getCsr7_PersonPerformingStudyRegistration(int rep) {
        XCN retVal = (XCN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getCsr7_PersonPerformingStudyRegistrationReps() {
        return this.getReps(7);
    }

    public XCN insertPersonPerformingStudyRegistration(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN insertCsr7_PersonPerformingStudyRegistration(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(7, rep);
    }

    public XCN removePersonPerformingStudyRegistration(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN removeCsr7_PersonPerformingStudyRegistration(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(7, rep);
    }

    public XCN[] getStudyAuthorizingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public XCN[] getCsr8_StudyAuthorizingProvider() {
        XCN[] retVal = (XCN[])this.getTypedField(8, new XCN[0]);
        return retVal;
    }

    public int getStudyAuthorizingProviderReps() {
        return this.getReps(8);
    }

    public XCN getStudyAuthorizingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public XCN getCsr8_StudyAuthorizingProvider(int rep) {
        XCN retVal = (XCN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getCsr8_StudyAuthorizingProviderReps() {
        return this.getReps(8);
    }

    public XCN insertStudyAuthorizingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN insertCsr8_StudyAuthorizingProvider(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(8, rep);
    }

    public XCN removeStudyAuthorizingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public XCN removeCsr8_StudyAuthorizingProvider(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(8, rep);
    }

    public DTM getDateTimePatientStudyConsentSigned() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public DTM getCsr9_DateTimePatientStudyConsentSigned() {
        DTM retVal = (DTM)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getPatientStudyEligibilityStatus() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getCsr10_PatientStudyEligibilityStatus() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public DTM[] getStudyRandomizationDateTime() {
        DTM[] retVal = (DTM[])this.getTypedField(11, new DTM[0]);
        return retVal;
    }

    public DTM[] getCsr11_StudyRandomizationDateTime() {
        DTM[] retVal = (DTM[])this.getTypedField(11, new DTM[0]);
        return retVal;
    }

    public int getStudyRandomizationDateTimeReps() {
        return this.getReps(11);
    }

    public DTM getStudyRandomizationDateTime(int rep) {
        DTM retVal = (DTM)this.getTypedField(11, rep);
        return retVal;
    }

    public DTM getCsr11_StudyRandomizationDateTime(int rep) {
        DTM retVal = (DTM)this.getTypedField(11, rep);
        return retVal;
    }

    public int getCsr11_StudyRandomizationDateTimeReps() {
        return this.getReps(11);
    }

    public DTM insertStudyRandomizationDateTime(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(11, rep);
    }

    public DTM insertCsr11_StudyRandomizationDateTime(int rep) throws HL7Exception {
        return (DTM)super.insertRepetition(11, rep);
    }

    public DTM removeStudyRandomizationDateTime(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(11, rep);
    }

    public DTM removeCsr11_StudyRandomizationDateTime(int rep) throws HL7Exception {
        return (DTM)super.removeRepetition(11, rep);
    }

    public CWE[] getRandomizedStudyArm() {
        CWE[] retVal = (CWE[])this.getTypedField(12, new CWE[0]);
        return retVal;
    }

    public CWE[] getCsr12_RandomizedStudyArm() {
        CWE[] retVal = (CWE[])this.getTypedField(12, new CWE[0]);
        return retVal;
    }

    public int getRandomizedStudyArmReps() {
        return this.getReps(12);
    }

    public CWE getRandomizedStudyArm(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public CWE getCsr12_RandomizedStudyArm(int rep) {
        CWE retVal = (CWE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getCsr12_RandomizedStudyArmReps() {
        return this.getReps(12);
    }

    public CWE insertRandomizedStudyArm(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE insertCsr12_RandomizedStudyArm(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(12, rep);
    }

    public CWE removeRandomizedStudyArm(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    public CWE removeCsr12_RandomizedStudyArm(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(12, rep);
    }

    public CWE[] getStratumForStudyRandomization() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public CWE[] getCsr13_StratumForStudyRandomization() {
        CWE[] retVal = (CWE[])this.getTypedField(13, new CWE[0]);
        return retVal;
    }

    public int getStratumForStudyRandomizationReps() {
        return this.getReps(13);
    }

    public CWE getStratumForStudyRandomization(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public CWE getCsr13_StratumForStudyRandomization(int rep) {
        CWE retVal = (CWE)this.getTypedField(13, rep);
        return retVal;
    }

    public int getCsr13_StratumForStudyRandomizationReps() {
        return this.getReps(13);
    }

    public CWE insertStratumForStudyRandomization(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE insertCsr13_StratumForStudyRandomization(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(13, rep);
    }

    public CWE removeStratumForStudyRandomization(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public CWE removeCsr13_StratumForStudyRandomization(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(13, rep);
    }

    public CWE getPatientEvaluabilityStatus() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public CWE getCsr14_PatientEvaluabilityStatus() {
        CWE retVal = (CWE)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getDateTimeEndedStudy() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public DTM getCsr15_DateTimeEndedStudy() {
        DTM retVal = (DTM)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getReasonEndedStudy() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getCsr16_ReasonEndedStudy() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CX(this.getMessage());
            }
            case 4: {
                return new CX(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new XCN(this.getMessage());
            }
            case 7: {
                return new XCN(this.getMessage());
            }
            case 8: {
                return new DTM(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new DTM(this.getMessage());
            }
            case 11: {
                return new CWE(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new DTM(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

