/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.bdi.breaks.ActivityBreakpoint;
import org.apache.ode.bpel.bdi.breaks.Breakpoint;
import org.apache.ode.bpel.bdi.breaks.VariableModificationBreakpoint;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.ProcessAndInstanceManagementImpl;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.pmapi.BpelManagementFacade;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.InstanceNotFoundException;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.pmapi.TInstanceInfo;
import org.apache.ode.bpel.runtime.breaks.ActivityBreakpointImpl;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ScopeDAO;
import org.apache.ode.dao.bpel.XmlDataDAO;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.uuid.UUIDGen;
import org.w3c.dom.Node;

public class BpelManagementFacadeImpl
extends ProcessAndInstanceManagementImpl
implements BpelManagementFacade {
    private static UUIDGen _uuidGen = new UUIDGen();

    public BpelManagementFacadeImpl(BpelServer server, ProcessStore store) {
        super(server, store);
    }

    public short getState(final Long iid) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<Short>(){

            @Override
            public Short run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                return instance.getState();
            }
        });
    }

    public Long getProcessInstance(String pid, final CorrelationKey ckey) throws ManagementException {
        BpelProcessDatabase bpelProcessDatabase = this._db.getProcessDb(QName.valueOf(pid));
        bpelProcessDatabase.getClass();
        return this.dbexec(new BpelProcessDatabase.Callable<Long>(bpelProcessDatabase){

            @Override
            public Long run(BpelDAOConnection session) throws Exception {
                Iterator i = this.getProcessDAO().findInstance(ckey).iterator();
                return i.hasNext() ? ((ProcessInstanceDAO)i.next()).getInstanceId() : null;
            }
        });
    }

    public EventInfoListDocument getEvents(Long iid, int startIdx, int count) throws ManagementException {
        List<String> timeline;
        try {
            timeline = this.getEventTimeline("iid=" + iid, null);
        }
        catch (Exception ex) {
            throw new ManagementException("Unable to retrieve timeline.", (Throwable)ex);
        }
        if (startIdx >= timeline.size()) {
            return EventInfoListDocument.Factory.newInstance();
        }
        timeline = timeline.subList(startIdx, Math.min(timeline.size(), startIdx + count));
        String startdt = timeline.get(0);
        String enddt = timeline.get(timeline.size() - 1);
        return this.listEvents("iid=" + iid, "timestamp>=" + startdt + " " + "timestamp<=" + enddt, 0);
    }

    public int getEventCount(Long iid) throws ManagementException {
        TInstanceInfo.EventInfo einfo = this.getInstanceInfo(iid).getInstanceInfo().getEventInfo();
        if (einfo == null) {
            return 0;
        }
        return einfo.getCount();
    }

    public String getVariable(final Long iid, final Long scopeId, final String varName) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<String>(){

            @Override
            public String run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                if (instance == null) {
                    throw new ManagementException("InstanceNotFound:" + iid);
                }
                ScopeDAO scope = instance.getScope(scopeId);
                if (scope == null) {
                    throw new ManagementException("ScopeNotFound:" + scopeId);
                }
                XmlDataDAO var = scope.getVariable(varName);
                if (var == null) {
                    throw new ManagementException("VarNotFound:" + varName);
                }
                return BpelManagementFacadeImpl.nodeToString(var);
            }
        });
    }

    public Long[] getScopeInstancesForScope(final Long iid, final String scopeName) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<Long[]>(){

            @Override
            public Long[] run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                if (instance == null) {
                    throw new ManagementException("InstanceNotFound:" + iid);
                }
                Collection scopes = instance.getScopes(scopeName);
                ArrayList<Long> instanceIds = new ArrayList<Long>(scopes.size());
                for (ScopeDAO i : scopes) {
                    instanceIds.add(i.getScopeInstanceId());
                }
                return instanceIds.toArray(new Long[scopes.size()]);
            }
        });
    }

    public void setVariable(Long pid, Long scopeId, String varName, String data) {
        throw new UnsupportedOperationException();
    }

    public void setCorrelation(final Long iid, Long scopeId, final String correlationSet, final QName[] propertyNames, final CorrelationKey values) throws ManagementException {
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                if (instance == null) {
                    throw new ManagementException("InstanceNotFound:" + iid);
                }
                CorrelationSetDAO correlationSetDAO = instance.getCorrelationSet(correlationSet);
                correlationSetDAO.setValue(propertyNames, values);
                return null;
            }
        });
    }

    public CorrelationKey getCorrelation(final Long iid, final Long scopeId, final String correlationSet) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<CorrelationKey>(){

            @Override
            public CorrelationKey run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                if (instance == null) {
                    throw new ManagementException("InstanceNotFound:" + iid);
                }
                CorrelationSetDAO corr = BpelManagementFacadeImpl.this.findCorrelationSetDAO(instance, scopeId, correlationSet);
                return corr.getValue();
            }
        });
    }

    public OProcess getProcessDef(String procid) throws ManagementException {
        if (this._server._engine == null) {
            throw new ProcessingException("ServiceProvider required for debugger operation.");
        }
        BpelProcess process = this._server._engine._activeProcesses.get(QName.valueOf(procid));
        if (process == null) {
            throw new InvalidRequestException("The process \"" + procid + "\" is not available. Please make sure it is deployed and encompassing System is activated.");
        }
        return process.getOProcess();
    }

    public void step(Long iid) throws ManagementException {
        DebuggerSupport debugSupport = this.getDebugger(iid);
        assert (debugSupport != null) : "getDebugger(Long) returned NULL!";
        debugSupport.step(iid);
    }

    public QName getCompletedFault(final Long iid) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<QName>(){

            @Override
            public QName run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                if (instance == null) {
                    throw new ManagementException("InstanceNotFound:" + iid);
                }
                return instance.getFault().getName();
            }
        });
    }

    public Breakpoint[] getGlobalBreakpoints(String procId) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(QName.valueOf(procId));
        return debuggerSupport.getGlobalBreakpoints();
    }

    public Breakpoint[] getBreakpoints(Long iid) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(iid);
        return debuggerSupport.getBreakpoints(iid);
    }

    public void removeGlobalBreakpoint(String procid, Breakpoint sp) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(QName.valueOf(procid));
        debuggerSupport.removeGlobalBreakpoint(sp);
    }

    public void removeBreakpoint(Long iid, Breakpoint sp) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(iid);
        debuggerSupport.removeBreakpoint(iid, sp);
    }

    public ActivityBreakpoint addGlobalActivityBreakpoint(String procid, String activity) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(QName.valueOf(procid));
        ActivityBreakpointImpl bp = new ActivityBreakpointImpl(_uuidGen.nextUUID(), activity);
        debuggerSupport.addGlobalBreakpoint(bp);
        return bp;
    }

    public ActivityBreakpoint addActivityBreakpoint(Long iid, String activity) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(iid);
        ActivityBreakpointImpl bp = new ActivityBreakpointImpl(_uuidGen.nextUUID(), activity);
        debuggerSupport.addBreakpoint(iid, bp);
        return bp;
    }

    public VariableModificationBreakpoint addVariableModificationBreakpoint(Long iid, String scopename, String variable) {
        throw new UnsupportedOperationException();
    }

    public Date getStartTime(final Long iid) throws ManagementException {
        return this.dbexec(new BpelDatabase.Callable<Date>(){

            @Override
            public Date run(BpelDAOConnection session) throws Exception {
                ProcessInstanceDAO instance = session.getInstance(iid);
                if (instance == null) {
                    throw new InstanceNotFoundException("InstanceNotFound:" + iid);
                }
                return instance.getCreateTime();
            }
        });
    }

    private CorrelationSetDAO findCorrelationSetDAO(ProcessInstanceDAO instance, Long scopeId, String correlationSet) throws ManagementException {
        ScopeDAO scope = instance.getScope(scopeId);
        CorrelationSetDAO corr = null;
        while ((corr = scope.getCorrelationSet(correlationSet)) == null && (scope = scope.getParentScope()) != null) {
        }
        if (corr == null) {
            throw new ManagementException("CorrelationSetNotFound:" + correlationSet);
        }
        return corr;
    }

    private static String nodeToString(XmlDataDAO xml) {
        Node data = xml.get();
        String str = data == null ? null : (data.getNodeType() == 1 ? DOMUtils.domToString((Node)data) : data.getNodeValue());
        return str;
    }
}

