/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.dom;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.ResourceConfigurationNotFoundException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.Filter;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.VisitSequence;
import org.milyn.delivery.dom.DOMContentDeliveryConfig;
import org.milyn.delivery.dom.DOMParser;
import org.milyn.delivery.dom.DOMVisitAfter;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.dom.VisitPhase;
import org.milyn.delivery.dom.serialize.Serializer;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.AbstractReportGenerator;
import org.milyn.event.types.DOMFilterLifecycleEvent;
import org.milyn.event.types.ElementPresentEvent;
import org.milyn.event.types.ElementVisitEvent;
import org.milyn.event.types.ResourceTargetingEvent;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaSource;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksDOMFilter
extends Filter {
    private Log logger = LogFactory.getLog(SmooksDOMFilter.class);
    private ExecutionContext executionContext;
    private DOMContentDeliveryConfig deliveryConfig;
    public static final String DELIVERY_NODE_REQUEST_KEY = ContentDeliveryConfig.class.getName() + "#DELIVERY_NODE_REQUEST_KEY";
    private ExecutionEventListener eventListener;
    private boolean closeSource;
    private boolean closeResult;
    private boolean reverseVisitOrderOnVisitAfter;
    private boolean terminateOnVisitorException;
    private List<ContentHandlerConfigMap<DOMVisitBefore>> globalAssemblyBefores;
    private List<ContentHandlerConfigMap<DOMVisitAfter>> globalAssemblyAfters;
    private List<ContentHandlerConfigMap<DOMVisitBefore>> globalProcessingBefores;
    private List<ContentHandlerConfigMap<DOMVisitAfter>> globalProcessingAfters;
    private static String[] GLOBAL_SELECTORS = new String[]{"*", "**"};

    public SmooksDOMFilter(ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in constructor call.");
        }
        this.executionContext = executionContext;
        this.deliveryConfig = (DOMContentDeliveryConfig)executionContext.getDeliveryConfig();
        this.eventListener = executionContext.getEventListener();
        this.closeSource = ParameterAccessor.getBoolParameter("close.source", true, executionContext.getDeliveryConfig());
        this.closeResult = ParameterAccessor.getBoolParameter("close.result", true, executionContext.getDeliveryConfig());
        this.reverseVisitOrderOnVisitAfter = ParameterAccessor.getBoolParameter("reverse.visit.order.on.visit.after", true, executionContext.getDeliveryConfig());
        this.terminateOnVisitorException = !(executionContext.getEventListener() instanceof AbstractReportGenerator) ? ParameterAccessor.getBoolParameter("terminate.on.visitor.exception", true, executionContext.getDeliveryConfig()) : false;
    }

    @Override
    public void doFilter() throws SmooksException {
        Source source = FilterSource.getSource(this.executionContext);
        Result result = FilterResult.getResult(this.executionContext, StreamResult.class);
        if (result == null) {
            result = FilterResult.getResult(this.executionContext, DOMResult.class);
        }
        this.doFilter(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFilter(Source source, Result result) {
        if (!(source instanceof StreamSource || source instanceof DOMSource || source instanceof JavaSource)) {
            throw new IllegalArgumentException(source.getClass().getName() + " Source types not yet supported by the DOM Filter.");
        }
        if (!(result instanceof FilterResult || result == null || result instanceof StreamResult || result instanceof DOMResult)) {
            throw new IllegalArgumentException(result.getClass().getName() + " Result types not yet supported by the DOM Filter.");
        }
        try {
            Node resultNode;
            if (source instanceof DOMSource) {
                Node node = ((DOMSource)source).getNode();
                if (node instanceof Document) {
                    resultNode = this.filter((Document)node);
                } else {
                    if (!(node instanceof Element)) throw new IllegalArgumentException("DOMSource Source types must contain a Document or Element node.");
                    resultNode = this.filter((Element)node);
                }
            } else {
                resultNode = this.filter(source);
            }
            if (result instanceof StreamResult) {
                StreamResult streamResult = (StreamResult)result;
                Writer writer = this.getWriter(streamResult, this.executionContext);
                try {
                    this.serialize(resultNode, writer);
                    writer.flush();
                    return;
                }
                catch (IOException e) {
                    this.logger.debug((Object)"Error writing result to output stream.", (Throwable)e);
                }
                return;
            } else {
                if (!(result instanceof DOMResult)) return;
                ((DOMResult)result).setNode(resultNode);
            }
            return;
        }
        finally {
            if (this.closeSource) {
                this.close(source);
            }
            if (this.closeResult) {
                this.close(result);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    public Node filter(Source source) throws SmooksException {
        Node deliveryNode;
        if (source == null) {
            throw new IllegalArgumentException("null 'source' arg passed in method call.");
        }
        try {
            DOMParser parser = new DOMParser(this.executionContext);
            Document document = parser.parse(source);
            deliveryNode = this.filter(document);
        }
        catch (Exception cause) {
            throw new SmooksException("Unable to filter InputStream for target profile [" + this.executionContext.getTargetProfiles().getBaseProfile() + "].", cause);
        }
        return deliveryNode;
    }

    public Node filter(Document doc) {
        if (doc.getDocumentElement() == null) {
            this.logger.debug((Object)("Empty Document [" + this.executionContext.getDocumentSource() + "].  Not performaing any processing."));
            return doc;
        }
        Node deliveryNode = this.filter(doc.getDocumentElement());
        if (deliveryNode == null) {
            deliveryNode = doc;
        }
        return deliveryNode;
    }

    public Node filter(Element element) {
        ContentHandlerConfigMapTable<DOMVisitBefore> visitBefores = this.deliveryConfig.getAssemblyVisitBefores();
        ContentHandlerConfigMapTable<DOMVisitAfter> visitAfters = this.deliveryConfig.getAssemblyVisitAfters();
        this.globalAssemblyBefores = visitBefores.getMappings(GLOBAL_SELECTORS);
        this.globalAssemblyAfters = visitAfters.getMappings(GLOBAL_SELECTORS);
        if (this.eventListener != null) {
            this.eventListener.onEvent(new DOMFilterLifecycleEvent(DOMFilterLifecycleEvent.DOMEventType.ASSEMBLY_STARTED));
        }
        if (this.applyAssembly(visitBefores, visitAfters)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Starting assembly phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
            }
            this.assemble(element, true);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No assembly units configured for device [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
        }
        if (this.eventListener != null) {
            this.eventListener.onEvent(new DOMFilterLifecycleEvent(DOMFilterLifecycleEvent.DOMEventType.PROCESSING_STARTED));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting processing phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
        }
        this.globalProcessingBefores = this.deliveryConfig.getProcessingVisitBefores().getMappings(GLOBAL_SELECTORS);
        if (this.globalProcessingBefores != null && this.globalProcessingBefores.isEmpty()) {
            this.globalProcessingBefores = null;
        }
        this.globalProcessingAfters = this.deliveryConfig.getProcessingVisitAfters().getMappings(GLOBAL_SELECTORS);
        if (this.globalProcessingAfters != null && this.globalProcessingAfters.isEmpty()) {
            this.globalProcessingAfters = null;
        }
        Vector transList = new Vector();
        this.buildProcessingList(transList, element, true);
        int transListLength = transList.size();
        for (int i = 0; i < transListLength; ++i) {
            ElementProcessor elementTrans = (ElementProcessor)transList.get(i);
            elementTrans.process(this.executionContext);
        }
        return (Node)this.executionContext.getAttribute(DELIVERY_NODE_REQUEST_KEY);
    }

    private List<ContentHandlerConfigMap<? extends ContentHandler>> getGlobalConfigs(ContentHandlerConfigMapTable<? extends ContentHandler> assemblyVisitBefores) {
        return null;
    }

    private boolean applyAssembly(ContentHandlerConfigMapTable<DOMVisitBefore> visitBefores, ContentHandlerConfigMapTable<DOMVisitAfter> visitAfters) {
        return !visitBefores.isEmpty() || !visitAfters.isEmpty() || this.globalAssemblyBefores != null && !this.globalAssemblyBefores.isEmpty() || this.globalAssemblyAfters != null && !this.globalAssemblyAfters.isEmpty();
    }

    private void assemble(Element element, boolean isRoot) {
        List<ContentHandlerConfigMap<DOMVisitAfter>> elementVisitAfters;
        List<ContentHandlerConfigMap<DOMVisitBefore>> elementVisitBefores;
        List nodeListCopy = this.copyList(element.getChildNodes());
        int childCount = nodeListCopy.size();
        ContentHandlerConfigMapTable<DOMVisitBefore> visitBeforeTable = this.deliveryConfig.getAssemblyVisitBefores();
        ContentHandlerConfigMapTable<DOMVisitAfter> visitAfterTable = this.deliveryConfig.getAssemblyVisitAfters();
        String elementName = DomUtils.getName(element);
        if (this.eventListener != null) {
            this.eventListener.onEvent(new ElementPresentEvent(element));
        }
        if (isRoot) {
            elementVisitBefores = visitBeforeTable.getMappings(new String[]{"#document", elementName});
            elementVisitAfters = visitAfterTable.getMappings(new String[]{"#document", elementName});
        } else {
            elementVisitBefores = visitBeforeTable.getMappings(elementName);
            elementVisitAfters = visitAfterTable.getMappings(elementName);
        }
        if (elementVisitBefores != null && !elementVisitBefores.isEmpty()) {
            this.applyAssemblyBefores(element, elementVisitBefores);
        }
        if (this.globalAssemblyBefores != null && !this.globalAssemblyBefores.isEmpty()) {
            this.applyAssemblyBefores(element, this.globalAssemblyBefores);
        }
        for (int i = 0; i < childCount; ++i) {
            Node child = (Node)nodeListCopy.get(i);
            if (child.getNodeType() != 1) continue;
            this.assemble((Element)child, false);
        }
        if (elementVisitAfters != null && !elementVisitAfters.isEmpty()) {
            this.applyAssemblyAfters(element, elementVisitAfters);
        }
        if (this.globalAssemblyAfters != null && !this.globalAssemblyAfters.isEmpty()) {
            this.applyAssemblyAfters(element, this.globalAssemblyAfters);
        }
    }

    private void applyAssemblyBefores(Element element, List<ContentHandlerConfigMap<DOMVisitBefore>> assemblyBefores) {
        for (int i = 0; i < assemblyBefores.size(); ++i) {
            ContentHandlerConfigMap<DOMVisitBefore> configMap = assemblyBefores.get(i);
            SmooksResourceConfiguration config = configMap.getResourceConfig();
            if (!config.isTargetedAtElement(element, this.executionContext)) continue;
            if (this.eventListener != null) {
                this.eventListener.onEvent(new ResourceTargetingEvent((Object)element, config, VisitSequence.BEFORE, new Object[]{VisitPhase.ASSEMBLY}));
            }
            DOMVisitBefore assemblyUnit = configMap.getContentHandler();
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("(Assembly) Calling visitBefore on element [" + DomUtils.getXPath(element) + "]. Config [" + config + "]"));
                }
                assemblyUnit.visitBefore(element, this.executionContext);
                if (this.eventListener == null) continue;
                this.eventListener.onEvent(new ElementVisitEvent(element, configMap, VisitSequence.BEFORE));
                continue;
            }
            catch (Throwable e) {
                String errorMsg = "(Assembly) visitBefore failed [" + assemblyUnit.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
                this.processVisitorException(element, e, configMap, VisitSequence.BEFORE, errorMsg);
            }
        }
    }

    private void applyAssemblyAfters(Element element, List<ContentHandlerConfigMap<DOMVisitAfter>> elementVisitAfters) {
        if (this.reverseVisitOrderOnVisitAfter) {
            for (int i = elementVisitAfters.size() - 1; i >= 0; --i) {
                ContentHandlerConfigMap<DOMVisitAfter> configMap = elementVisitAfters.get(i);
                this.applyAssemblyAfter(element, configMap);
            }
        } else {
            for (int i = 0; i < elementVisitAfters.size(); ++i) {
                ContentHandlerConfigMap<DOMVisitAfter> configMap = elementVisitAfters.get(i);
                this.applyAssemblyAfter(element, configMap);
            }
        }
    }

    private void applyAssemblyAfter(Element element, ContentHandlerConfigMap<DOMVisitAfter> configMap) {
        SmooksResourceConfiguration config = configMap.getResourceConfig();
        if (!config.isTargetedAtElement(element, this.executionContext)) {
            return;
        }
        DOMVisitAfter visitAfter = configMap.getContentHandler();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("(Assembly) Calling visitAfter on element [" + DomUtils.getXPath(element) + "]. Config [" + config + "]"));
            }
            visitAfter.visitAfter(element, this.executionContext);
            if (this.eventListener != null) {
                this.eventListener.onEvent(new ElementVisitEvent(element, configMap, VisitSequence.AFTER));
            }
        }
        catch (Throwable e) {
            String errorMsg = "(Assembly) visitAfter failed [" + visitAfter.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
            this.processVisitorException(element, e, configMap, VisitSequence.AFTER, errorMsg);
        }
    }

    private void buildProcessingList(List processingList, Element element, boolean isRoot) {
        ElementProcessor processor;
        List<ContentHandlerConfigMap<VisitLifecycleCleanable>> processingCleanables;
        List<ContentHandlerConfigMap<DOMVisitAfter>> processingAfters;
        List<ContentHandlerConfigMap<DOMVisitBefore>> processingBefores;
        if (this.eventListener != null) {
            this.eventListener.onEvent(new ElementPresentEvent(element));
        }
        String elementName = DomUtils.getName(element);
        if (isRoot) {
            processingBefores = this.deliveryConfig.getProcessingVisitBefores().getMappings(new String[]{"#document", elementName});
            processingAfters = this.deliveryConfig.getProcessingVisitAfters().getMappings(new String[]{"#document", elementName});
            processingCleanables = this.deliveryConfig.getVisitCleanables().getMappings(new String[]{"#document", elementName});
        } else {
            processingBefores = this.deliveryConfig.getProcessingVisitBefores().getMappings(elementName);
            processingAfters = this.deliveryConfig.getProcessingVisitAfters().getMappings(elementName);
            processingCleanables = this.deliveryConfig.getVisitCleanables().getMappings(elementName);
        }
        if (processingBefores != null && !processingBefores.isEmpty()) {
            processor = new ElementProcessor(element);
            processor.setVisitBefores(processingBefores);
            processingList.add(processor);
        }
        if (this.globalProcessingBefores != null) {
            processor = new ElementProcessor(element);
            processor.setVisitBefores(this.globalProcessingBefores);
            processingList.add(processor);
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.buildProcessingList(processingList, (Element)child, false);
        }
        if (processingAfters != null && !processingAfters.isEmpty()) {
            ElementProcessor processor2 = new ElementProcessor(element);
            processor2.setVisitAfters(processingAfters);
            processingList.add(processor2);
        }
        if (this.globalProcessingAfters != null) {
            ElementProcessor processor3 = new ElementProcessor(element);
            processor3.setVisitAfters(this.globalProcessingAfters);
            processingList.add(processor3);
        }
        if (processingCleanables != null && !processingCleanables.isEmpty()) {
            ElementProcessor processor4 = new ElementProcessor(element);
            processor4.setVisitCleanable(processingCleanables);
            processingList.add(processor4);
        }
    }

    public void serialize(Node node, Writer writer) throws IOException, SmooksException {
        if (node == null) {
            throw new IllegalArgumentException("null 'doc' arg passed in method call.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null 'writer' arg passed in method call.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Starting serialization phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]"));
        }
        Serializer serializer = new Serializer(node, this.executionContext);
        try {
            serializer.serailize(writer);
        }
        catch (ResourceConfigurationNotFoundException e) {
            throw new SmooksException("Unable to serialize document.", e);
        }
    }

    private List copyList(NodeList nodeList) {
        Vector<Node> copy = new Vector<Node>(nodeList.getLength());
        int nodeCount = nodeList.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            copy.add(nodeList.item(i));
        }
        return copy;
    }

    private void processVisitorException(Element element, Throwable error, ContentHandlerConfigMap configMapping, VisitSequence visitSequence, String errorMsg) throws SmooksException {
        if (this.eventListener != null) {
            this.eventListener.onEvent(new ElementVisitEvent(element, configMapping, visitSequence, error));
        }
        this.executionContext.setTerminationError(error);
        if (this.terminateOnVisitorException) {
            if (error instanceof SmooksException) {
                throw (SmooksException)error;
            }
            throw new SmooksException(errorMsg, error);
        }
        this.logger.debug((Object)errorMsg, error);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementProcessor {
        private Element element;
        private List<ContentHandlerConfigMap<DOMVisitBefore>> visitBefores;
        private List<ContentHandlerConfigMap<DOMVisitAfter>> visitAfters;
        private List<ContentHandlerConfigMap<VisitLifecycleCleanable>> visitCleanable;

        private ElementProcessor(Element element) {
            this.element = element;
        }

        private void setVisitBefores(List<ContentHandlerConfigMap<DOMVisitBefore>> visitBefores) {
            this.visitBefores = visitBefores;
        }

        private void setVisitAfters(List<ContentHandlerConfigMap<DOMVisitAfter>> visitAfters) {
            this.visitAfters = visitAfters;
        }

        public void setVisitCleanable(List<ContentHandlerConfigMap<VisitLifecycleCleanable>> visitCleanable) {
            this.visitCleanable = visitCleanable;
        }

        private void process(ExecutionContext executionContext) {
            if (this.visitBefores != null) {
                int loopLength = this.visitBefores.size();
                for (int i = 0; i < loopLength; ++i) {
                    ContentHandlerConfigMap<DOMVisitBefore> configMap = this.visitBefores.get(i);
                    this.processMapping(executionContext, configMap, VisitSequence.BEFORE);
                }
            } else if (this.visitAfters != null) {
                int loopLength = this.visitAfters.size();
                if (SmooksDOMFilter.this.reverseVisitOrderOnVisitAfter) {
                    for (int i = loopLength - 1; i >= 0; --i) {
                        ContentHandlerConfigMap<DOMVisitAfter> configMap = this.visitAfters.get(i);
                        this.processMapping(executionContext, configMap, VisitSequence.AFTER);
                    }
                } else {
                    for (int i = 0; i < loopLength; ++i) {
                        ContentHandlerConfigMap<DOMVisitAfter> configMap = this.visitAfters.get(i);
                        this.processMapping(executionContext, configMap, VisitSequence.AFTER);
                    }
                }
            } else {
                int loopLength = this.visitCleanable.size();
                for (int i = 0; i < loopLength; ++i) {
                    ContentHandlerConfigMap<VisitLifecycleCleanable> configMap = this.visitCleanable.get(i);
                    this.processMapping(executionContext, configMap, VisitSequence.CLEAN);
                }
            }
        }

        private void processMapping(ExecutionContext executionContext, ContentHandlerConfigMap configMap, VisitSequence visitSequence) {
            SmooksResourceConfiguration config = configMap.getResourceConfig();
            if (!config.isTargetedAtElement(this.element, executionContext)) {
                return;
            }
            if (visitSequence == VisitSequence.BEFORE) {
                if (SmooksDOMFilter.this.eventListener != null) {
                    SmooksDOMFilter.this.eventListener.onEvent(new ResourceTargetingEvent((Object)this.element, config, VisitSequence.BEFORE, new Object[0]));
                }
                DOMVisitBefore visitor = (DOMVisitBefore)configMap.getContentHandler();
                try {
                    if (SmooksDOMFilter.this.logger.isDebugEnabled()) {
                        SmooksDOMFilter.this.logger.debug((Object)("Applying processing resource [" + config + "] to element [" + DomUtils.getXPath(this.element) + "] before applying resources to its child elements."));
                    }
                    visitor.visitBefore(this.element, executionContext);
                    if (SmooksDOMFilter.this.eventListener != null) {
                        SmooksDOMFilter.this.eventListener.onEvent(new ElementVisitEvent(this.element, configMap, VisitSequence.BEFORE));
                    }
                }
                catch (Throwable e) {
                    String errorMsg = "Failed to apply processing unit [" + visitor.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                    SmooksDOMFilter.this.processVisitorException(this.element, e, configMap, VisitSequence.BEFORE, errorMsg);
                }
            } else if (visitSequence == VisitSequence.AFTER) {
                if (SmooksDOMFilter.this.eventListener != null) {
                    SmooksDOMFilter.this.eventListener.onEvent(new ResourceTargetingEvent((Object)this.element, config, VisitSequence.AFTER, new Object[0]));
                }
                DOMVisitAfter visitor = (DOMVisitAfter)configMap.getContentHandler();
                try {
                    if (SmooksDOMFilter.this.logger.isDebugEnabled()) {
                        SmooksDOMFilter.this.logger.debug((Object)("Applying processing resource [" + config + "] to element [" + DomUtils.getXPath(this.element) + "] after applying resources to its child elements."));
                    }
                    visitor.visitAfter(this.element, executionContext);
                    if (SmooksDOMFilter.this.eventListener != null) {
                        SmooksDOMFilter.this.eventListener.onEvent(new ElementVisitEvent(this.element, configMap, VisitSequence.AFTER));
                    }
                }
                catch (Throwable e) {
                    String errorMsg = "Failed to apply processing unit [" + visitor.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                    SmooksDOMFilter.this.processVisitorException(this.element, e, configMap, VisitSequence.BEFORE, errorMsg);
                }
            } else if (visitSequence == VisitSequence.CLEAN) {
                Object contentHandler;
                if (SmooksDOMFilter.this.eventListener != null) {
                    SmooksDOMFilter.this.eventListener.onEvent(new ResourceTargetingEvent((Object)this.element, config, VisitSequence.CLEAN, new Object[0]));
                }
                if ((contentHandler = configMap.getContentHandler()) instanceof VisitLifecycleCleanable) {
                    VisitLifecycleCleanable visitor = (VisitLifecycleCleanable)contentHandler;
                    try {
                        if (SmooksDOMFilter.this.logger.isDebugEnabled()) {
                            SmooksDOMFilter.this.logger.debug((Object)("Cleaning up processing resource [" + config + "] that was targeted to element [" + DomUtils.getXPath(this.element) + "]."));
                        }
                        visitor.executeVisitLifecycleCleanup(new Fragment(this.element), executionContext);
                        if (SmooksDOMFilter.this.eventListener != null) {
                            SmooksDOMFilter.this.eventListener.onEvent(new ElementVisitEvent(this.element, configMap, VisitSequence.CLEAN));
                        }
                    }
                    catch (Throwable e) {
                        String errorMsg = "Failed to clean up [" + visitor.getClass().getName() + "]. Targeted at [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                        SmooksDOMFilter.this.processVisitorException(this.element, e, configMap, VisitSequence.CLEAN, errorMsg);
                    }
                }
            }
        }
    }
}

