/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashSet;
import org.apache.ode.utils.ProcessMutex;

public final class GUID
implements Cloneable,
Comparable,
Serializable {
    static final long serialVersionUID = -7977671257884186039L;
    static String PROP_PORT = "org.apache.ode.uid.port";
    static int port = Integer.getInteger(PROP_PORT, 33666);
    private static final byte[] ipadd = new byte[]{127, 0, 0, 1};
    private static byte[] baseId = GUID.getSystemUniqId();
    private static short cnt = Short.MIN_VALUE;
    private static GUID _VM_GUID = new GUID();
    private final byte[] id;
    private transient String guidstring = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUID() {
        Class<GUID> clazz = GUID.class;
        synchronized (GUID.class) {
            short c = cnt = (short)(cnt + 1);
            byte[] b = baseId;
            if (cnt == Short.MAX_VALUE) {
                cnt = Short.MIN_VALUE;
                baseId = GUID.getSystemUniqId();
            }
            // ** MonitorExit[var3_1] (shouldn't be in output)
            this.id = new byte[]{ipadd[0], ipadd[1], ipadd[2], ipadd[3], b[7], b[6], b[5], b[4], b[3], b[2], b[1], b[0], (byte)(c >>> 8 & 0xFF), (byte)(c & 0xFF)};
            return;
        }
    }

    public GUID(String str) throws MalformedGuidException {
        if (str == null) {
            throw new MalformedGuidException(str);
        }
        this.id = new byte[14];
        this.stringToBytes(str);
    }

    public byte[] getGuid() {
        return this.id;
    }

    public static GUID getVMGUID() {
        return _VM_GUID;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        GUID o1 = (GUID)o;
        for (int i = 0; i < this.id.length; i = (int)((short)(i + 1))) {
            if (o1.id[i] < this.id[i]) {
                return -1;
            }
            if (o1.id[i] <= this.id[i]) continue;
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        try {
            return this.compareTo(o) == 0;
        }
        catch (ClassCastException ce) {
            return false;
        }
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.id.length; i = (int)((short)(i + 1))) {
            ret ^= this.id[i] << i % 4;
        }
        return ret;
    }

    public static void main(String[] argv) throws Exception {
        HashSet<GUID> set = new HashSet<GUID>();
        for (int i = 0; i < 100000; ++i) {
            GUID g = new GUID();
            if (set.contains(g)) {
                System.out.println("CONFLICT>>>");
            }
            set.add(g);
            GUID ng = new GUID(g.toString());
            if (!ng.toString().equals(g.toString()) || !ng.equals(g)) {
                System.out.println("INEQUALITY>>>");
                System.out.println(ng.toString());
                System.out.println(g.toString());
                continue;
            }
            System.out.println(g.toString());
        }
    }

    public String toString() {
        if (this.guidstring == null) {
            this.guidstring = this.mapBytesToChars();
        }
        return this.guidstring;
    }

    private static byte[] getSystemUniqId() {
        ProcessMutex pm = new ProcessMutex(port);
        try {
            pm.lock();
        }
        catch (InterruptedException ie) {
            System.err.println("ERROR: Could not establish unique starttime using\n       TCP port " + port + " for synchronization. \n" + "       Perhaps this port is used by anotherprocess? \n" + "       Check the '" + PROP_PORT + "' JAVA system property. \n");
            throw new RuntimeException("GUID.getSystemUniqId() FAILED!!!");
        }
        long uid = System.currentTimeMillis();
        pm.unlock();
        return new byte[]{(byte)(uid & 0xFFL), (byte)(uid >>> 8 & 0xFFL), (byte)(uid >>> 16 & 0xFFL), (byte)(uid >>> 24 & 0xFFL), (byte)(uid >>> 32 & 0xFFL), (byte)(uid >>> 40 & 0xFFL), (byte)(uid >>> 48 & 0xFFL), (byte)(uid >>> 56 & 0xFFL)};
    }

    private String mapBytesToChars() {
        BigInteger bigInt = new BigInteger(this.id);
        return bigInt.toString(34);
    }

    private void stringToBytes(String s) {
        BigInteger bigInt = new BigInteger(s, 34);
        byte[] bytes = bigInt.toByteArray();
        for (int i = 0; i < this.id.length; ++i) {
            this.id[i] = bytes[i];
        }
    }

    public static String makeGUID(String digest) {
        String val = "0";
        int maxlen = 32;
        int base = 34;
        int prime = 31;
        for (int i = 0; i < digest.length(); ++i) {
            char c = digest.charAt(i);
            if ((val = new BigInteger(val, base).add(BigInteger.valueOf(c)).multiply(BigInteger.valueOf(prime)).toString(base)).length() <= maxlen) continue;
            val = val.substring(0, maxlen);
        }
        return val;
    }

    public static class MalformedGuidException
    extends Exception {
        private static final long serialVersionUID = -8922336058603571809L;

        public MalformedGuidException(String guid) {
            super("Malformed guid: " + guid);
        }
    }
}

