/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.StringTokenizer;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.Fragments;

public class ConsoleFormatter {
    private static final int LINE_WIDTH = 76;
    private static final int LEFT_MARGIN = 20;

    private static String spaces(int n) {
        StringBuffer sb = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String formatUsage(String command, Fragments f) {
        StringBuffer sb = new StringBuffer(command + " ");
        String spaces = ConsoleFormatter.spaces(command.length() + 1);
        int currentLineLength = sb.length();
        CommandlineFragment[] ff = f.getFragmentsInUserOrder();
        for (int i = 0; i < ff.length; ++i) {
            String u = ff[i].getUsage();
            if (ff[i].isOptional()) {
                u = "[" + u + "]";
            }
            if (currentLineLength != spaces.length() && currentLineLength + u.length() >= 76) {
                sb.append("\n");
                sb.append(spaces);
                currentLineLength = spaces.length();
            }
            if (currentLineLength != spaces.length()) {
                u = ' ' + u;
            }
            sb.append(u);
            currentLineLength += u.length();
        }
        return sb.toString();
    }

    public static String formatHelp(Fragments f) {
        CommandlineFragment[] ff = f.getFragmentsInUserOrder();
        StringBuffer sb = new StringBuffer();
        String spaces = ConsoleFormatter.spaces(20);
        for (int i = 0; i < ff.length; ++i) {
            String u = ff[i].getUsage();
            if (u.length() > 20) {
                sb.append(u);
                sb.append('\n');
                sb.append(spaces);
            } else {
                sb.append(ConsoleFormatter.rightPadToWidth(u, 20));
            }
            sb.append(ConsoleFormatter.wrap(ff[i].getDescription(), 20));
        }
        return sb.toString();
    }

    public static String rightPadToWidth(String s, int w) {
        if (s.length() > w) {
            return s;
        }
        return s + ConsoleFormatter.spaces(w - s.length());
    }

    public static String wrap(String s, int left) {
        String spaces = ConsoleFormatter.spaces(left);
        int cll = left;
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (cll != left && cll + t.length() > 76) {
                sb.append('\n');
                sb.append(spaces);
                cll = left;
            }
            if (cll != left) {
                t = ' ' + t;
            }
            sb.append(t);
            cll += t.length();
        }
        sb.append('\n');
        return sb.toString();
    }

    public static void printSynopsis(String command, String synposis, Fragments[] frags) {
        System.out.print(command + " - ");
        System.out.println(ConsoleFormatter.wrap(synposis, command.length() + 3));
        for (int i = 0; i < frags.length; ++i) {
            System.out.println(ConsoleFormatter.formatUsage(command, frags[i]));
            System.out.println(ConsoleFormatter.formatHelp(frags[i]));
        }
    }
}

