/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class Flag
implements CommandlineFragment {
    private String _name;
    private boolean _isSet;
    private String _description;
    private boolean _isOptional;

    public Flag(String name, String description, boolean optional) {
        this._name = "-" + name;
        this._description = description;
        this._isSet = false;
        this._isOptional = optional;
    }

    @Override
    public void reset() {
        this._isSet = false;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }

    @Override
    public List<String> consume(List<String> s) throws CommandlineSyntaxException {
        this._isSet = s.contains(this._name);
        if (!this._isSet && !this._isOptional) {
            throw new CommandlineSyntaxException("The " + this._name + " flag is required.");
        }
        ArrayList<String> l = new ArrayList<String>(s);
        l.remove(this._name);
        if (l.contains(this._name)) {
            throw new CommandlineSyntaxException("The " + this._name + " flag can appear at most once.");
        }
        return l;
    }

    public boolean isSet() {
        return this._isSet;
    }

    @Override
    public String getUsage() {
        return this._name;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public boolean validate() {
        return true;
    }
}

