/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.switchyard.Property;
import org.switchyard.common.codec.Base64;
import org.switchyard.remote.RemoteInvoker;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteMessages;
import org.switchyard.remote.http.HttpInvokerLabel;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public class HttpInvoker
implements RemoteInvoker {
    public static final String SERVICE_HEADER = "switchyard-service";
    public static final String AUTH_USERNAME = "auth.username";
    public static final String AUTH_PASSWORD = "auth.password";
    private static Logger _log = Logger.getLogger(HttpInvoker.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private URL _endpoint;
    private Properties _properties = new Properties();

    public HttpInvoker(String endpoint) {
        try {
            this._endpoint = new URL(endpoint);
        }
        catch (MalformedURLException badURL) {
            throw RemoteMessages.MESSAGES.invalidURLForEndpoint(endpoint, badURL);
        }
    }

    public HttpInvoker(URL endpoint) {
        this._endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteMessage invoke(RemoteMessage request) throws IOException {
        RemoteMessage reply = null;
        HttpURLConnection conn = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking " + request.getService() + " at endpoint " + this._endpoint.toString()));
        }
        conn = (HttpURLConnection)this._endpoint.openConnection();
        conn.setDoOutput(true);
        conn.addRequestProperty(SERVICE_HEADER, request.getService().toString());
        for (Property prop : request.getContext().getProperties(HttpInvokerLabel.HEADER.label())) {
            conn.addRequestProperty(prop.getName(), prop.getValue().toString());
        }
        this.setupAuthentication(conn);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        try {
            this._serializer.serialize((Object)request, RemoteMessage.class, os);
            os.flush();
        }
        finally {
            os.close();
        }
        if (conn.getResponseCode() == 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing reply for service " + request.getService()));
            }
            InputStream is = conn.getInputStream();
            try {
                reply = (RemoteMessage)this._serializer.deserialize(is, RemoteMessage.class);
            }
            finally {
                is.close();
            }
        }
        return reply;
    }

    private void setupAuthentication(HttpURLConnection conn) {
        if (this._properties.getProperty(AUTH_USERNAME) != null) {
            conn.setRequestProperty("Authorization", "Basic " + Base64.encodeFromString((String)(this._properties.getProperty(AUTH_USERNAME) + ":" + this._properties.getProperty(AUTH_PASSWORD))));
        }
    }

    public HttpInvoker setProperty(Object key, Object value) {
        this._properties.put(key, value);
        return this;
    }
}

