/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelEngineImpl;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.DehydrationPolicy;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.ProcessCleanUpRunnable;
import org.apache.ode.bpel.engine.cron.CronScheduler;
import org.apache.ode.bpel.engine.migration.MigrationHandler;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEngine;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.DebuggerContext;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.intercept.MessageExchangeInterceptor;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.bpel.DeferredProcessInstanceCleanable;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.xsl.XslTransformHandler;

public class BpelServerImpl
implements BpelServer,
Scheduler.JobProcessor {
    private static final Log __log = LogFactory.getLog(BpelServerImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static Long __processMaxAge;
    public static final String DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED_NAME = "org.apache.ode.disable.deferredProcessInstanceCleanup";
    private static boolean DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED;
    public static final String PERSIST_BPEL_EVENTS = "persist.bpel.events";
    private final Set<BpelProcess> _registeredProcesses = new HashSet<BpelProcess>();
    private State _state = State.SHUTDOWN;
    private final Contexts _contexts = new Contexts();
    private Properties _configProperties;
    private DehydrationPolicy _dehydrationPolicy;
    private boolean _hydrationLazy;
    private int _hydrationLazyMinimumSize;
    private int _migrationTransactionTimeout;
    private Thread processDefReaper;
    BpelEngineImpl _engine;
    protected BpelDatabase _db;
    private ReadWriteLock _mngmtLock = new ReentrantReadWriteLock();

    public Contexts getContexts() {
        return this._contexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.INIT, State.RUNNING)) {
                __log.debug((Object)"start() ignored -- already started");
                return;
            }
            __log.debug((Object)"BPEL SERVER starting.");
            if (!new MigrationHandler(this._contexts).migrate(this._registeredProcesses, this._migrationTransactionTimeout)) {
                throw new RuntimeException("An error occurred while migrating your database to a newer version of the server. Please make sure that the required migration scripts have been executed before starting the server.");
            }
            this._state = State.RUNNING;
            __log.info((Object)__msgs.msgServerStarted());
            if (this._dehydrationPolicy != null) {
                this.processDefReaper = new Thread((Runnable)new ProcessDefReaper(), "Dehydrator");
                this.processDefReaper.setDaemon(true);
                this.processDefReaper.start();
            }
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void registerExternalVariableEngine(ExternalVariableModule eve) {
        this._contexts.externalVariableEngines.put(eve.getName(), eve);
    }

    public void registerBpelEventListener(BpelEventListener listener) {
        listener.startup(this._configProperties);
        this._contexts.eventListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBpelEventListener(BpelEventListener listener) {
        try {
            listener.shutdown();
        }
        catch (Exception e) {
            __log.warn((Object)("Stopping BPEL event listener " + listener.getClass().getName() + " failed, nevertheless it has been unregistered."), (Throwable)e);
        }
        finally {
            this._contexts.eventListeners.remove(listener);
        }
    }

    private void unregisterBpelEventListeners() {
        for (BpelEventListener l : this._contexts.eventListeners) {
            this.unregisterBpelEventListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.RUNNING, State.INIT)) {
                __log.debug((Object)"stop() ignored -- already stopped");
                return;
            }
            __log.debug((Object)"BPEL SERVER STOPPING");
            if (this.processDefReaper != null) {
                this.processDefReaper.interrupt();
                this.processDefReaper = null;
            }
            this._contexts.scheduler.stop();
            this._engine = null;
            this._state = State.INIT;
            __log.info((Object)__msgs.msgServerStopped());
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            if (!this.checkState(State.SHUTDOWN, State.INIT)) {
                return;
            }
            __log.debug((Object)"BPEL SERVER initializing ");
            this._db = new BpelDatabase(this._contexts.dao, this._contexts.scheduler);
            this._state = State.INIT;
            this._engine = this.createBpelEngineImpl(this._contexts);
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    protected BpelEngineImpl createBpelEngineImpl(Contexts contexts) {
        return new BpelEngineImpl(contexts, this._configProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws BpelEngineException {
        this._mngmtLock.writeLock().lock();
        try {
            this.stop();
            this.unregisterBpelEventListeners();
            this._db = null;
            this._engine = null;
            this._state = State.SHUTDOWN;
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BpelEngine getEngine() {
        boolean registered = false;
        this._mngmtLock.readLock().lock();
        try {
            this._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

                public void afterCompletion(boolean success) {
                    BpelServerImpl.this._mngmtLock.readLock().unlock();
                }

                public void beforeCompletion() {
                }
            });
            registered = true;
        }
        finally {
            if (!registered) {
                this._mngmtLock.readLock().unlock();
            }
        }
        return this._engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ProcessConf conf) {
        if (conf == null) {
            throw new NullPointerException("must specify non-null process configuration.");
        }
        __log.debug((Object)("register: " + conf.getProcessId()));
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            __log.debug((Object)"register(...) interrupted.", (Throwable)ie);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            if (this._engine.isProcessRegistered(conf.getProcessId())) {
                __log.debug((Object)("skipping doRegister" + conf.getProcessId() + ") -- process is already registered"));
                return;
            }
            __log.debug((Object)("Registering process " + conf.getProcessId() + " with server."));
            BpelProcess process = this.createBpelProcess(conf);
            process._classLoader = Thread.currentThread().getContextClassLoader();
            process.setPersistBpelEvents(this._configProperties.getProperty(PERSIST_BPEL_EVENTS, Boolean.TRUE.toString()).equalsIgnoreCase(Boolean.TRUE.toString()));
            this._engine.registerProcess(process);
            this._registeredProcesses.add(process);
            if (!this.isLazyHydratable(process)) {
                process.hydrate();
            } else {
                this._engine.setProcessSize(process.getPID(), false);
            }
            __log.info((Object)__msgs.msgProcessRegistered(conf.getProcessId()));
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    private boolean isLazyHydratable(BpelProcess process) {
        if (process.isHydrationLazySet()) {
            return process.isHydrationLazy();
        }
        if (!this._hydrationLazy) {
            return false;
        }
        return process.getEstimatedHydratedSize() < (long)this._hydrationLazyMinimumSize;
    }

    protected BpelProcess createBpelProcess(ProcessConf conf) {
        return new BpelProcess(conf);
    }

    public void unregister(QName pid) throws BpelEngineException {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)("unregister: " + pid));
        }
        try {
            this._mngmtLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            __log.debug((Object)"unregister() interrupted.", (Throwable)ie);
            throw new BpelEngineException(__msgs.msgOperationInterrupted());
        }
        try {
            BpelProcess p = null;
            if (this._engine != null && (p = this._engine.unregisterProcess(pid)) != null) {
                this._registeredProcesses.remove(p);
                XslTransformHandler.getInstance().clearXSLSheets(p.getProcessType());
                __log.info((Object)__msgs.msgProcessUnregistered(pid));
            }
        }
        catch (Exception ex) {
            __log.error((Object)__msgs.msgProcessUnregisterFailed(pid), (Throwable)ex);
            throw new BpelEngineException((Throwable)ex);
        }
        finally {
            this._mngmtLock.writeLock().unlock();
        }
    }

    public void registerMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._contexts.globalInterceptors.add(interceptor);
    }

    public void unregisterMessageExchangeInterceptor(MessageExchangeInterceptor interceptor) {
        this._contexts.globalInterceptors.remove(interceptor);
    }

    private boolean checkState(State i, State j) {
        if (this._state == i) {
            return true;
        }
        if (this._state == j) {
            return false;
        }
        return false;
    }

    protected boolean deleteProcessDAO(final QName pid, boolean isInMemory) {
        try {
            if (isInMemory) {
                return this.deleteProcessDAO(this._contexts.inMemDao.getConnection(), pid);
            }
            return this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection conn) throws Exception {
                    return BpelServerImpl.this.deleteProcessDAO(conn, pid);
                }
            });
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean deleteProcessDAO(BpelDAOConnection conn, QName pid) {
        ProcessDAO proc = conn.getProcess(pid);
        if (proc != null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Deleting only the process " + pid + "..."));
            }
            proc.deleteProcessAndRoutes();
            if (__log.isInfoEnabled()) {
                __log.info((Object)("Deleted only the process " + pid + "."));
            }
            if (proc instanceof DeferredProcessInstanceCleanable && !DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED) {
                this._engine._contexts.scheduler.scheduleMapSerializableRunnable((Scheduler.MapSerializableRunnable)new ProcessCleanUpRunnable(((DeferredProcessInstanceCleanable)proc).getId()), new Date());
            } else if (proc instanceof DeferredProcessInstanceCleanable) {
                ((DeferredProcessInstanceCleanable)proc).deleteInstances(Integer.MAX_VALUE);
            }
            return true;
        }
        return false;
    }

    public void onScheduledJob(Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
        this.getEngine().onScheduledJob(jobInfo);
    }

    public void setDehydrationPolicy(DehydrationPolicy dehydrationPolicy) {
        this._dehydrationPolicy = dehydrationPolicy;
    }

    public void setConfigProperties(Properties configProperties) {
        this._configProperties = configProperties;
    }

    public void setMessageExchangeContext(MessageExchangeContext mexContext) throws BpelEngineException {
        this._contexts.mexContext = mexContext;
    }

    public void setScheduler(Scheduler scheduler) throws BpelEngineException {
        this._contexts.scheduler = scheduler;
    }

    public void setCronScheduler(CronScheduler cronScheduler) throws BpelEngineException {
        this._contexts.cronScheduler = cronScheduler;
    }

    public void setEndpointReferenceContext(EndpointReferenceContext eprContext) throws BpelEngineException {
        this._contexts.eprContext = eprContext;
    }

    public void setDaoConnectionFactory(BpelDAOConnectionFactory daoCF) throws BpelEngineException {
        this._contexts.dao = daoCF;
    }

    public void setInMemDaoConnectionFactory(BpelDAOConnectionFactory daoCF) {
        this._contexts.inMemDao = daoCF;
    }

    public void setBindingContext(BindingContext bc) {
        this._contexts.bindingContext = bc;
    }

    public DebuggerContext getDebugger(QName pid) throws BpelEngineException {
        return this._engine._activeProcesses.get((Object)pid)._debugger;
    }

    public boolean hasActiveInstances(final QName pid) {
        try {
            return this._db.exec(new BpelDatabase.Callable<Boolean>(){

                @Override
                public Boolean run(BpelDAOConnection conn) throws Exception {
                    return conn.getNumInstances(pid) > 0;
                }
            });
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setHydrationLazy(boolean hydrationLazy) {
        this._hydrationLazy = hydrationLazy;
    }

    public void setProcessThrottledMaximumSize(long hydrationThrottledMaximumSize) {
        this._engine.setProcessThrottledMaximumSize(hydrationThrottledMaximumSize);
    }

    public void setProcessThrottledMaximumCount(int hydrationThrottledMaximumCount) {
        this._engine.setProcessThrottledMaximumCount(hydrationThrottledMaximumCount);
    }

    public void setHydrationLazyMinimumSize(int hydrationLazyMinimumSize) {
        this._hydrationLazyMinimumSize = hydrationLazyMinimumSize;
    }

    public void setInstanceThrottledMaximumCount(int instanceThrottledMaximumCount) {
        this._engine.setInstanceThrottledMaximumCount(instanceThrottledMaximumCount);
    }

    public void setXTSEnable(boolean xtsEnable) {
        this._engine.setXTSEnable(xtsEnable);
    }

    public void cleanupProcess(ProcessConf pconf) throws BpelEngineException {
        if (pconf != null) {
            this.deleteProcessDAO(pconf.getProcessId(), pconf.isTransient());
        }
    }

    public void setMigrationTransactionTimeout(int migrationTransactionTimeout) {
        this._migrationTransactionTimeout = migrationTransactionTimeout;
    }

    static {
        DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED = Boolean.getBoolean(DEFERRED_PROCESS_INSTANCE_CLEANUP_DISABLED_NAME);
        try {
            String processMaxAge = System.getProperty("ode.process.maxage");
            if (processMaxAge != null && processMaxAge.length() > 0) {
                __processMaxAge = Long.valueOf(processMaxAge);
                __log.info((Object)("Process definition max age adjusted. Max age = " + __processMaxAge + "ms."));
            }
        }
        catch (Throwable t) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Could not parse ode.process.maxage environment variable.", t);
            }
            __log.info((Object)"Could not parse ode.process.maxage environment variable; reaping disabled.");
        }
    }

    public static class PolledRunnableProcessor
    implements Scheduler.JobProcessor {
        private ExecutorService _polledRunnableExec;
        private Contexts _contexts;
        private final Map<String, PolledRunnableResults> resultsByJobId = new HashMap<String, PolledRunnableResults>();

        public void setContexts(Contexts contexts) {
            this._contexts = contexts;
        }

        public void setPolledRunnableExecutorService(ExecutorService polledRunnableExecutorService) {
            this._polledRunnableExec = polledRunnableExecutorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onScheduledJob(final Scheduler.JobInfo jobInfo) throws Scheduler.JobProcessorException {
            JOB_STATUS statusOfPriorTry = JOB_STATUS.PENDING;
            Exception exceptionThrownOnPriorTry = null;
            boolean toRetry = false;
            Map<String, PolledRunnableResults> map = this.resultsByJobId;
            synchronized (map) {
                PolledRunnableResults results = this.resultsByJobId.get(jobInfo.jobName);
                if (results != null) {
                    statusOfPriorTry = results._status;
                    exceptionThrownOnPriorTry = results._exception;
                }
                if (statusOfPriorTry == JOB_STATUS.COMPLETED) {
                    this.resultsByJobId.remove(jobInfo.jobName);
                    jobInfo.jobDetail.getDetailsExt().put("runnable_status", JOB_STATUS.COMPLETED);
                    return;
                }
                if (statusOfPriorTry == JOB_STATUS.PENDING || statusOfPriorTry == JOB_STATUS.FAILED) {
                    this.resultsByJobId.put(jobInfo.jobName, new PolledRunnableResults(JOB_STATUS.IN_PROGRESS, null));
                    toRetry = true;
                }
            }
            if (toRetry) {
                this._polledRunnableExec.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Scheduler.MapSerializableRunnable runnable = (Scheduler.MapSerializableRunnable)jobInfo.jobDetail.getDetailsExt().get("runnable");
                            runnable.restoreFromDetails(jobInfo.jobDetail);
                            if (runnable instanceof ContextsAware) {
                                ((ContextsAware)runnable).setContexts(PolledRunnableProcessor.this._contexts);
                            }
                            runnable.run();
                            Map map = PolledRunnableProcessor.this.resultsByJobId;
                            synchronized (map) {
                                PolledRunnableProcessor.this.resultsByJobId.put(jobInfo.jobName, new PolledRunnableResults(JOB_STATUS.COMPLETED, null));
                            }
                        }
                        catch (Exception e) {
                            __log.error((Object)"", (Throwable)e);
                            Map map = PolledRunnableProcessor.this.resultsByJobId;
                            synchronized (map) {
                                PolledRunnableProcessor.this.resultsByJobId.put(jobInfo.jobName, new PolledRunnableResults(JOB_STATUS.FAILED, e));
                            }
                        }
                    }
                });
            }
            jobInfo.jobDetail.getDetailsExt().put("runnable_status", JOB_STATUS.IN_PROGRESS);
            if (exceptionThrownOnPriorTry != null) {
                throw new Scheduler.JobProcessorException((Throwable)exceptionThrownOnPriorTry, true);
            }
        }

        private class PolledRunnableResults {
            private JOB_STATUS _status = JOB_STATUS.PENDING;
            private Exception _exception;

            public PolledRunnableResults(JOB_STATUS status, Exception exception) {
                this._status = status;
                this._exception = exception;
            }
        }

        private static enum JOB_STATUS {
            PENDING,
            IN_PROGRESS,
            FAILED,
            COMPLETED;

        }
    }

    public static interface ContextsAware {
        public void setContexts(Contexts var1);
    }

    private class ProcessDefReaper
    implements Runnable {
        private ProcessDefReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            __log.debug((Object)"Starting process definition reaper thread.");
            long pollingTime = 10000L;
            try {
                block5: while (true) {
                    Thread.sleep(pollingTime);
                    if (!BpelServerImpl.this._mngmtLock.writeLock().tryLock(100L, TimeUnit.MILLISECONDS)) continue;
                    try {
                        __log.debug((Object)("Kicking reaper, OProcess instances: " + OProcess.instanceCount));
                        ArrayList<BpelProcess> candidates = new ArrayList<BpelProcess>(BpelServerImpl.this._registeredProcesses);
                        CollectionsX.remove_if(candidates, (MemberOfFunction)new MemberOfFunction<BpelProcess>(){

                            public boolean isMember(BpelProcess o) {
                                return !o.hintIsHydrated();
                            }
                        });
                        List<BpelProcess> ripped = BpelServerImpl.this._dehydrationPolicy.markForDehydration(candidates);
                        Iterator<BpelProcess> i$ = ripped.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block5;
                            BpelProcess process = i$.next();
                            __log.debug((Object)("Dehydrating process " + process.getPID()));
                            process.dehydrate();
                        }
                    }
                    finally {
                        BpelServerImpl.this._mngmtLock.writeLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                __log.debug((Object)e);
                return;
            }
        }
    }

    private static enum State {
        SHUTDOWN,
        INIT,
        RUNNING;

    }
}

