/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.extvar.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.extvar.jdbc.EVarId;
import org.apache.ode.bpel.extvar.jdbc.GenType;
import org.apache.ode.bpel.extvar.jdbc.InitType;
import org.apache.ode.bpel.extvar.jdbc.RowSubset;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ISO8601DateParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DbExternalVariable {
    private static final Log __log = LogFactory.getLog(DbExternalVariable.class);
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    EVarId evarId;
    DataSource dataSource;
    final ArrayList<Column> _columns = new ArrayList();
    private final HashMap<String, Column> _colmap = new HashMap();
    final ArrayList<Column> _keycolumns = new ArrayList();
    final ArrayList<Column> _inscolumns = new ArrayList();
    final ArrayList<Column> _updcolumns = new ArrayList();
    InitType _initType = InitType.update_insert;
    public String[] _autoColNames;
    String select;
    String insert;
    String update;
    String table;
    String schema;
    boolean generatedKeys;

    DbExternalVariable(EVarId evar, DataSource ds) {
        this.evarId = evar;
        this.dataSource = ds;
    }

    Column getColumn(String key) {
        return this._colmap.get(key);
    }

    void addColumn(Column c) {
        c.idx = this._columns.size();
        this._colmap.put(c.name, c);
        this._columns.add(c);
        if (c.key) {
            this._keycolumns.add(c);
            this._autoColNames = new String[this._keycolumns.size()];
            for (int i = 0; i < this._autoColNames.length; ++i) {
                this._autoColNames[i] = this._keycolumns.get((int)i).colname;
            }
        }
        this.createSelect();
        this.createInsert();
        this.createUpdate();
    }

    public int numColumns() {
        return this._columns.size();
    }

    RowKey keyFromLocator(ExternalVariableModule.Locator locator) throws ExternalVariableModuleException {
        RowKey rc = new RowKey();
        this.parseXmlRow(rc, locator.reference);
        for (Column c : rc._columns) {
            switch (c.genType) {
                case iid: 
                case pid: {
                    rc.put(c.name, c.getValue(c.name, null, null, locator.iid));
                }
            }
        }
        return rc;
    }

    private void createSelect() {
        StringBuilder sb = new StringBuilder("select ");
        boolean first = true;
        for (Column c : this._columns) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(c.colname);
        }
        sb.append(" from ");
        sb.append(this.schema + "." + this.table);
        if (this._keycolumns.size() > 0) {
            sb.append(" where ");
            first = true;
            for (Column kc : this._keycolumns) {
                if (!first) {
                    sb.append(" and ");
                }
                first = false;
                sb.append(kc.colname);
                sb.append(" = ?");
            }
            this.select = sb.toString();
        } else {
            this.select = null;
        }
    }

    private void createUpdate() {
        this._updcolumns.clear();
        StringBuilder sb = new StringBuilder("update ");
        sb.append(this.schema + "." + this.table);
        sb.append(" set ");
        boolean first = true;
        for (Column c : this._columns) {
            if (c.genType == GenType.sequence || c.key || c.genType == GenType.ctimestamp) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(c.colname);
            sb.append(" = ");
            if (c.genType == GenType.expression) {
                sb.append(c.expression);
                continue;
            }
            sb.append(" ?");
            this._updcolumns.add(c);
        }
        if (this._keycolumns.size() > 0) {
            sb.append(" where ");
            first = true;
            for (Column kc : this._keycolumns) {
                if (!first) {
                    sb.append(" and ");
                }
                first = false;
                sb.append(kc.colname);
                sb.append(" = ?");
            }
        }
        this.update = this._keycolumns.size() == 0 ? null : sb.toString();
    }

    private void createInsert() {
        this._inscolumns.clear();
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(this.schema + "." + this.table);
        sb.append(" ( ");
        boolean first = true;
        for (Column c : this._columns) {
            if (c.genType == GenType.sequence) continue;
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(c.colname);
        }
        sb.append(" ) ");
        sb.append(" values ( ");
        first = true;
        for (Column c : this._columns) {
            if (c.genType == GenType.sequence) continue;
            if (!first) {
                sb.append(',');
            }
            first = false;
            if (c.genType == GenType.expression) {
                sb.append(c.expression);
                continue;
            }
            sb.append(" ? ");
            this._inscolumns.add(c);
        }
        sb.append(" ) ");
        this.insert = sb.toString();
    }

    <T extends RowSubset> Element renderXmlRow(ExternalVariableModule.Locator locator, QName varType, T value) throws ExternalVariableModuleException {
        Document doc = DOMUtils.newDocument();
        Element el = doc.createElementNS(varType.getNamespaceURI(), varType.getLocalPart());
        doc.appendChild(el);
        if (value != null) {
            for (Column c : value._columns) {
                Object data = value.get(c.idx);
                this.addElement(el, varType, c, data);
            }
        } else {
            RowKey keys = this.keyFromLocator(locator);
            for (Column c : this._columns) {
                Object data = c.getValue(c.name, keys, new RowVal(), locator.iid);
                this.addElement(el, varType, c, data);
            }
        }
        return el;
    }

    private void addElement(Element parent, QName varType, Column c, Object data) {
        Document doc = parent.getOwnerDocument();
        Element cel = doc.createElementNS(varType.getNamespaceURI(), c.name);
        String strdat = c.toText(data);
        if (strdat != null) {
            cel.appendChild(doc.createTextNode(strdat));
        } else if (c.nullok || c.isGenerated()) {
            cel.setAttributeNS(XSI_NS, "xsi:nil", "true");
        }
        parent.appendChild(cel);
    }

    <T extends RowSubset> T parseXmlRow(T ret, Node rowel) throws ExternalVariableModuleException {
        if (rowel == null) {
            return ret;
        }
        NodeList nl = rowel.getChildNodes();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("parseXmlRow: element=" + rowel.getLocalName()));
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Column column;
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            String key = n.getLocalName();
            String val = n.getTextContent();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Extvar key: " + key + " value: " + val));
            }
            if ((column = ret.getColumn(key)) == null) {
                if (!__log.isDebugEnabled()) continue;
                __log.debug((Object)("No matching column for key '" + key + "'"));
                continue;
            }
            String nil = ((Element)n).getAttributeNS(XSI_NS, "nil");
            if (nil != null && "true".equalsIgnoreCase(nil) && (val == null || val.trim().length() == 0)) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Extvar key: " + key + " is null (xsi:nil)"));
                }
                ret.put(key, null);
                continue;
            }
            ret.put(key, column.fromText(val));
        }
        return ret;
    }

    class RowVal
    extends RowSubset {
        private static final long serialVersionUID = 1L;

        RowVal() {
            super((List<Column>)DbExternalVariable.this._columns);
        }
    }

    class RowKey
    extends RowSubset {
        private static final long serialVersionUID = 1L;

        RowKey() {
            super((List<Column>)DbExternalVariable.this._keycolumns);
        }

        void write(QName varType, ExternalVariableModule.Locator locator) throws ExternalVariableModuleException {
            locator.reference = DbExternalVariable.this.renderXmlRow(locator, varType, this);
        }

        public Set<String> getMissing() {
            HashSet<String> missing = new HashSet<String>();
            for (Column c : DbExternalVariable.this._keycolumns) {
                if (this.get(c.idx) != null) continue;
                missing.add(c.name);
            }
            return missing;
        }
    }

    class Column {
        int idx;
        final String name;
        final String colname;
        final boolean key;
        final GenType genType;
        final String expression;
        int dataType;
        boolean nullok;

        Column(String name, String colname, boolean key, GenType genType, String expression) {
            this.name = name;
            this.colname = colname == null ? name : colname;
            this.key = key;
            this.genType = genType;
            this.expression = expression;
        }

        public Object getValue(String name, RowKey keys, RowVal values, Long iid) {
            switch (this.genType) {
                case ctimestamp: 
                case utimestamp: {
                    return this.isTimeStamp() ? new Timestamp(new java.util.Date().getTime()) : new java.util.Date();
                }
                case uuid: {
                    return new GUID().toString();
                }
                case pid: {
                    return DbExternalVariable.this.evarId.pid.toString();
                }
                case iid: {
                    return iid;
                }
            }
            if (this.key && keys.get(name) != null) {
                return keys.get(name);
            }
            return values.get(name);
        }

        boolean supportsEmptyValue() {
            return this.dataType == 12 || this.dataType == -1 || this.dataType == 2005;
        }

        boolean isDate() {
            return this.dataType == 91;
        }

        boolean isTimeStamp() {
            return this.dataType == 93;
        }

        boolean isTime() {
            return this.dataType == 92;
        }

        boolean isInteger() {
            switch (this.dataType) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }

        boolean isReal() {
            switch (this.dataType) {
                case 2: 
                case 3: 
                case 7: {
                    return true;
                }
            }
            return false;
        }

        boolean isBoolean() {
            switch (this.dataType) {
                case -7: {
                    return true;
                }
            }
            return false;
        }

        String toText(Object val) {
            if (val == null) {
                return null;
            }
            java.util.Date date = null;
            if (val instanceof java.util.Date) {
                date = (java.util.Date)val;
                return ISO8601DateParser.format((java.util.Date)((java.util.Date)val));
            }
            return val.toString();
        }

        Object fromText(String val) throws ExternalVariableModuleException {
            try {
                if (val == null) {
                    return null;
                }
                if (!this.supportsEmptyValue() && val.trim().length() == 0) {
                    return null;
                }
                if (this.isDate()) {
                    return new Date(ISO8601DateParser.parse((String)val).getTime());
                }
                if (this.isTime()) {
                    return new Time(ISO8601DateParser.parse((String)val).getTime());
                }
                if (this.isTimeStamp()) {
                    return new Timestamp(ISO8601DateParser.parse((String)val).getTime());
                }
                if (this.isInteger()) {
                    String v = val.trim().toLowerCase();
                    if (v.equals("true")) {
                        return 1;
                    }
                    if (v.equals("false")) {
                        return 0;
                    }
                    return new BigDecimal(val).longValue();
                }
                if (this.isReal()) {
                    return Double.valueOf(val);
                }
                if (this.isBoolean()) {
                    String v = val.trim();
                    if (v.equals("1")) {
                        return true;
                    }
                    if (v.equals("0")) {
                        return false;
                    }
                    return Boolean.valueOf(val);
                }
                return val;
            }
            catch (Exception ex) {
                throw new ExternalVariableModuleException("Unable to convert value \"" + val + "\" for column \"" + this.name + "\" !", (Throwable)ex);
            }
        }

        public boolean isGenerated() {
            return this.genType != null && !this.genType.equals((Object)GenType.none);
        }

        public boolean isDatabaseGenerated() {
            return this.isGenerated() && (this.genType.equals((Object)GenType.sequence) || this.genType.equals((Object)GenType.expression));
        }

        public String toString() {
            return "Column {idx=" + this.idx + ",name=" + this.name + ",colname=" + this.colname + ",key=" + this.key + ",genType=" + (Object)((Object)this.genType) + ")";
        }
    }
}

