/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.runtime;

import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.PartnerLinkModificationEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.VariableModificationEvent;
import org.apache.ode.bpel.explang.EvaluationContext;
import org.apache.ode.bpel.explang.EvaluationException;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OAssign;
import org.apache.ode.bpel.o.OElementVarType;
import org.apache.ode.bpel.o.OExpression;
import org.apache.ode.bpel.o.OLink;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.ACTIVITY;
import org.apache.ode.bpel.runtime.ASSIGNMessages;
import org.apache.ode.bpel.runtime.ActivityInfo;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.InvalidProcessException;
import org.apache.ode.bpel.runtime.LinkFrame;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.ScopeFrame;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.msg.MessageBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class AssignHelper
extends ACTIVITY {
    private static final long serialVersionUID = 1L;
    private static final Log __log = LogFactory.getLog(AssignHelper.class);
    private static final ASSIGNMessages __msgs = (ASSIGNMessages)MessageBundle.getMessages(ASSIGNMessages.class);

    public AssignHelper(ActivityInfo self, ScopeFrame scopeFrame, LinkFrame linkFrame) {
        super(self, scopeFrame, linkFrame);
    }

    public void initVar(OScope.Variable var) throws FaultException, ExternalVariableModuleException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Initializing variable [" + var.name + "]"));
        }
        if (var.type instanceof OMessageVarType && var.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)var.from).isMessageRef()) {
            VariableInstance lval = this._scopeFrame.resolve(var);
            VariableInstance rval = this._scopeFrame.resolve(((OAssign.VariableRef)var.from).getVariable());
            Element lvalue = (Element)this.fetchVariableData(rval, false);
            this.initializeVariable(lval, lvalue);
        } else {
            Node rvalue = this.evalRValue(var.from);
            Node lvalue = this.evalLValue(var);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("rvalue after eval " + rvalue));
                if (rvalue != null) {
                    __log.debug((Object)("content " + DOMUtils.domToString((Node)rvalue)));
                }
            }
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("lvalue after eval " + rvalue));
                if (lvalue != null) {
                    __log.debug((Object)("content " + DOMUtils.domToString((Node)lvalue)));
                }
            }
            Node lvaluePtr = lvalue;
            if (var.from instanceof OAssign.PartnerLinkRef && (rvalue = this.getBpelRuntimeContext().convertEndpointReference((Element)rvalue, lvaluePtr)).getNodeType() == 9) {
                rvalue = ((Document)rvalue).getDocumentElement();
            }
            lvalue = rvalue.getNodeType() == 1 && lvaluePtr.getNodeType() == 1 ? this.replaceElement((Element)lvalue, (Element)lvaluePtr, (Element)rvalue, true) : this.replaceContent(lvalue, lvaluePtr, rvalue.getTextContent());
            VariableInstance lval = this._scopeFrame.resolve(var);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("SCOPE initialized variable '" + lval.declaration.name + "' value '" + DOMUtils.domToString((Node)lvalue) + "'"));
            }
            this.commitChanges(lval, lvalue);
        }
    }

    public Node evalLValue(OScope.Variable var) throws FaultException, ExternalVariableModuleException {
        BpelRuntimeContext napi = this.getBpelRuntimeContext();
        Node lval = null;
        VariableInstance lvar = this._scopeFrame.resolve(var);
        if (!napi.isVariableInitialized(lvar)) {
            Document doc = DOMUtils.newDocument();
            Node val = var.type.newInstance(doc);
            if (val.getNodeType() == 3) {
                Element tempwrapper = doc.createElementNS(null, "temporary-simple-type-wrapper");
                doc.appendChild(tempwrapper);
                tempwrapper.appendChild(val);
                val = tempwrapper;
            } else {
                doc.appendChild(val);
            }
            lval = lvar.declaration.extVar != null ? this.initializeVariable(lvar, val) : val;
        } else {
            lval = this.fetchVariableData(lvar, true);
        }
        return lval;
    }

    public void run() {
        String errMsg = "AssignHelper cannot be ran as ACTIVITY";
        __log.error((Object)errMsg);
        this._self.parent.failure(errMsg, null);
    }

    @Override
    protected Log log() {
        return __log;
    }

    private OActivity getOActivity() {
        return this._self.o;
    }

    private Node evalLValue(OAssign.LValue to) throws FaultException, ExternalVariableModuleException {
        BpelRuntimeContext napi = this.getBpelRuntimeContext();
        Node lval = null;
        if (!(to instanceof OAssign.PartnerLinkRef)) {
            VariableInstance lvar;
            try {
                lvar = this._scopeFrame.resolve(to.getVariable());
            }
            catch (RuntimeException e) {
                __log.error((Object)("iid: " + this.getBpelRuntimeContext().getPid() + " error evaluating lvalue"));
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, e.getMessage());
            }
            if (lvar == null) {
                String msg = __msgs.msgEvalException(to.toString(), "Could not resolve variable in current scope");
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(to + ": " + msg));
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg);
            }
            if (!napi.isVariableInitialized(lvar)) {
                Document doc = DOMUtils.newDocument();
                Node val = to.getVariable().type.newInstance(doc);
                if (val.getNodeType() == 3) {
                    Element tempwrapper = doc.createElementNS(null, "temporary-simple-type-wrapper");
                    doc.appendChild(tempwrapper);
                    tempwrapper.appendChild(val);
                    val = tempwrapper;
                } else {
                    doc.appendChild(val);
                }
                lval = lvar.declaration.extVar != null ? this.initializeVariable(lvar, val) : val;
            } else {
                lval = this.fetchVariableData(lvar, true);
            }
        }
        return lval;
    }

    private Node evalRValue(OAssign.RValue from) throws FaultException, ExternalVariableModuleException {
        String msg;
        Node retVal;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Evaluating FROM expression \"" + from + "\"."));
        }
        if (from instanceof OAssign.DirectRef) {
            OAssign.DirectRef dref = (OAssign.DirectRef)from;
            this.sendVariableReadEvent(this._scopeFrame.resolve(dref.variable));
            Node data = this.fetchVariableData(this._scopeFrame.resolve(dref.variable), false);
            retVal = DOMUtils.findChildByName((Element)((Element)data), (QName)dref.elName);
        } else if (from instanceof OAssign.VariableRef) {
            OAssign.VariableRef varRef = (OAssign.VariableRef)from;
            this.sendVariableReadEvent(this._scopeFrame.resolve(varRef.variable));
            Node data = this.fetchVariableData(this._scopeFrame.resolve(varRef.variable), false);
            retVal = this.evalQuery(data, varRef.part != null ? varRef.part : varRef.headerPart, varRef.location, this.getEvaluationContext());
        } else if (from instanceof OAssign.PropertyRef) {
            OAssign.PropertyRef propRef = (OAssign.PropertyRef)from;
            this.sendVariableReadEvent(this._scopeFrame.resolve(propRef.variable));
            Node data = this.fetchVariableData(this._scopeFrame.resolve(propRef.variable), false);
            retVal = this.evalQuery(data, propRef.propertyAlias.part, propRef.propertyAlias.location, this.getEvaluationContext());
        } else if (from instanceof OAssign.PartnerLinkRef) {
            Element tempVal;
            OAssign.PartnerLinkRef pLinkRef = (OAssign.PartnerLinkRef)from;
            PartnerLinkInstance pLink = this._scopeFrame.resolve(pLinkRef.partnerLink);
            Element element = tempVal = pLinkRef.isMyEndpointReference ? this.getBpelRuntimeContext().fetchMyRoleEndpointReferenceData(pLink) : this.getBpelRuntimeContext().fetchPartnerRoleEndpointReferenceData(pLink);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("RValue is a partner link, corresponding endpoint " + tempVal.getClass().getName() + " has value " + DOMUtils.domToString((Node)tempVal)));
            }
            retVal = tempVal;
        } else if (from instanceof OAssign.Expression) {
            List l;
            OExpression expr = ((OAssign.Expression)from).expression;
            try {
                l = this.getBpelRuntimeContext().getExpLangRuntime().evaluate(expr, this.getEvaluationContext());
            }
            catch (EvaluationException e) {
                String msg2 = __msgs.msgEvalException(from.toString(), e.getMessage());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(from + ": " + msg2));
                }
                if (e.getCause() instanceof FaultException) {
                    throw (FaultException)e.getCause();
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg2);
            }
            if (l.size() == 0) {
                String msg3 = __msgs.msgRValueNoNodesSelected(expr.toString());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(from + ": " + msg3));
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg3, new Throwable("ignoreMissingFromData"));
            }
            if (l.size() > 1) {
                String msg4 = __msgs.msgRValueMultipleNodesSelected(expr.toString());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(from + ": " + msg4));
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg4);
            }
            retVal = (Node)l.get(0);
        } else if (from instanceof OAssign.Literal) {
            Node x;
            Element literalRoot;
            String literal = ((OAssign.Literal)from).getXmlLiteral();
            try {
                literalRoot = DOMUtils.stringToDOM((String)literal);
            }
            catch (Exception e) {
                throw new RuntimeException("XML literal parsing failed " + literal, e);
            }
            assert (literalRoot.getLocalName().equals("literal"));
            literalRoot.normalize();
            retVal = literalRoot.getFirstChild();
            if (retVal != null && retVal.getNodeType() == 3 && retVal.getTextContent().trim().length() == 0 && retVal.getNextSibling() != null) {
                retVal = retVal.getNextSibling();
            }
            if (retVal == null) {
                retVal = literalRoot.getOwnerDocument().createTextNode("");
            } else if (retVal.getNodeType() == 1) {
                for (x = retVal.getNextSibling(); x != null; x = x.getNextSibling()) {
                    if (x.getNodeType() != 1) continue;
                    String msg5 = __msgs.msgLiteralContainsMultipleEIIs();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(from + ": " + msg5));
                    }
                    throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg5);
                }
            } else if (retVal.getNodeType() == 3) {
                for (x = retVal.getNextSibling(); x != null; x = x.getNextSibling()) {
                    if (x.getNodeType() != 1) continue;
                    String msg6 = __msgs.msgLiteralContainsMixedContent();
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)(from + ": " + msg6));
                    }
                    throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg6);
                }
            }
            if (retVal == null) {
                String msg7 = __msgs.msgLiteralMustContainTIIorEII();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(from + ": " + msg7));
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg7);
            }
        } else {
            String msg8 = __msgs.msgInternalError("Unknown RVALUE type: " + from);
            if (__log.isErrorEnabled()) {
                __log.error((Object)(from + ": " + msg8));
            }
            throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg8);
        }
        if (retVal == null) {
            msg = __msgs.msgEmptyRValue();
            if (__log.isDebugEnabled()) {
                __log.debug((Object)(from + ": " + msg));
            }
            throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg);
        }
        switch (retVal.getNodeType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                msg = __msgs.msgInvalidRValue();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(from + ": " + msg));
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg);
            }
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void copy(OAssign.Copy ocopy) throws FaultException, ExternalVariableModuleException {
        VariableModificationEvent se;
        block21: {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Assign.copy(" + ocopy + ")"));
            }
            if (ocopy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.to).isMessageRef() || ocopy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.from).isMessageRef()) {
                if (ocopy.to instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.to).isMessageRef() && ocopy.from instanceof OAssign.VariableRef && ((OAssign.VariableRef)ocopy.from).isMessageRef()) {
                    VariableInstance lval = this._scopeFrame.resolve(ocopy.to.getVariable());
                    VariableInstance rval = this._scopeFrame.resolve(((OAssign.VariableRef)ocopy.from).getVariable());
                    Element lvalue = (Element)this.fetchVariableData(rval, false);
                    this.initializeVariable(lval, lvalue);
                    se = new VariableModificationEvent(lval.declaration.name);
                    se.setNewValue((Node)lvalue);
                    break block21;
                } else {
                    __log.fatal((Object)("Message/Non-Message Assignment, should be caught by compiler:" + ocopy));
                    throw new FaultException(ocopy.getOwner().constants.qnSelectionFailure, "Message/Non-Message Assignment:  " + ocopy);
                }
            }
            Node rvalue = this.evalRValue(ocopy.from);
            Node lvalue = this.evalLValue(ocopy.to);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("lvalue after eval " + lvalue));
                if (lvalue != null) {
                    __log.debug((Object)("content " + DOMUtils.domToString((Node)lvalue)));
                }
            }
            Node lvaluePtr = lvalue;
            boolean headerAssign = false;
            if (ocopy.to instanceof OAssign.DirectRef) {
                OAssign.DirectRef dref = (OAssign.DirectRef)ocopy.to;
                Element el = DOMUtils.findChildByName((Element)((Element)lvalue), (QName)dref.elName);
                if (el == null) {
                    el = (Element)((Element)lvalue).appendChild(lvalue.getOwnerDocument().createElementNS(dref.elName.getNamespaceURI(), dref.elName.getLocalPart()));
                }
                lvaluePtr = el;
            } else if (ocopy.to instanceof OAssign.VariableRef) {
                OAssign.VariableRef varRef = (OAssign.VariableRef)ocopy.to;
                if (varRef.headerPart != null) {
                    headerAssign = true;
                }
                lvaluePtr = this.evalQuery(lvalue, varRef.part != null ? varRef.part : varRef.headerPart, varRef.location, new EvaluationContextProxy(varRef.getVariable(), lvalue));
            } else if (ocopy.to instanceof OAssign.PropertyRef) {
                OAssign.PropertyRef propRef = (OAssign.PropertyRef)ocopy.to;
                lvaluePtr = this.evalQuery(lvalue, propRef.propertyAlias.part, propRef.propertyAlias.location, new EvaluationContextProxy(propRef.getVariable(), lvalue));
            } else if (ocopy.to instanceof OAssign.LValueExpression) {
                OAssign.LValueExpression lexpr = (OAssign.LValueExpression)ocopy.to;
                lexpr.setInsertMissingToData(ocopy.insertMissingToData);
                lvaluePtr = this.evalQuery(lvalue, null, (OExpression)lexpr.expression, new EvaluationContextProxy(lexpr.getVariable(), lvalue));
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("lvaluePtr expr res " + lvaluePtr));
                }
            }
            if (ocopy.to instanceof OAssign.PartnerLinkRef) {
                OAssign.PartnerLinkRef pLinkRef = (OAssign.PartnerLinkRef)ocopy.to;
                PartnerLinkInstance plval = this._scopeFrame.resolve(pLinkRef.partnerLink);
                this.replaceEndpointRefence(plval, rvalue);
                se = new PartnerLinkModificationEvent(((OAssign.PartnerLinkRef)ocopy.to).partnerLink.getName());
            } else {
                if (ocopy.from instanceof OAssign.PartnerLinkRef && (rvalue = this.getBpelRuntimeContext().convertEndpointReference((Element)rvalue, lvaluePtr)).getNodeType() == 9) {
                    rvalue = ((Document)rvalue).getDocumentElement();
                }
                Node parentNode = lvaluePtr.getParentNode();
                lvalue = headerAssign && parentNode != null && "message".equals(parentNode.getNodeName()) && rvalue.getNodeType() == 1 ? this.copyInto((Element)lvalue, (Element)lvaluePtr, (Element)rvalue) : (rvalue.getNodeType() == 1 && lvaluePtr.getNodeType() == 1 ? this.replaceElement((Element)lvalue, (Element)lvaluePtr, (Element)rvalue, ocopy.keepSrcElementName) : this.replaceContent(lvalue, lvaluePtr, rvalue.getTextContent()));
                VariableInstance lval = this._scopeFrame.resolve(ocopy.to.getVariable());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ASSIGN Writing variable '" + lval.declaration.name + "' value '" + DOMUtils.domToString((Node)lvalue) + "'"));
                }
                this.commitChanges(lval, lvalue);
                se = new VariableModificationEvent(lval.declaration.name);
                se.setNewValue(lvalue);
            }
        }
        if (ocopy.debugInfo != null) {
            se.setLineNo(ocopy.debugInfo.startLine);
        }
        this.sendEvent((ScopeEvent)se);
    }

    @Override
    Node fetchVariableData(VariableInstance variable, boolean forWriting) throws FaultException {
        try {
            return super.fetchVariableData(variable, forWriting);
        }
        catch (FaultException fe) {
            if (forWriting) {
                fe = new FaultException(fe.getQName(), fe.getMessage(), new Throwable("throwUninitializedToVariable"));
            }
            throw fe;
        }
    }

    private void replaceEndpointRefence(PartnerLinkInstance plval, Node rvalue) throws FaultException {
        if (rvalue.getNodeType() == 2) {
            rvalue = rvalue.getOwnerDocument().createTextNode(((Attr)rvalue).getValue());
        }
        if (rvalue.getNodeType() == 3 || rvalue.getNodeType() == 1 && !rvalue.getLocalName().equals("service-ref")) {
            Document doc = DOMUtils.newDocument();
            Element serviceRef = doc.createElementNS(Namespaces.WSBPEL2_0_FINAL_SERVREF, "service-ref");
            doc.appendChild(serviceRef);
            serviceRef.appendChild(doc.importNode(rvalue, true));
            rvalue = serviceRef;
        }
        this.getBpelRuntimeContext().writeEndpointReference(plval, (Element)rvalue);
    }

    private Element replaceElement(Element lval, Element ptr, Element src, boolean keepSrcElement) {
        Document doc = ptr.getOwnerDocument();
        Node parent = ptr.getParentNode();
        if (keepSrcElement) {
            Element replacement = (Element)doc.importNode(src, true);
            parent.replaceChild(replacement, ptr);
            return lval == ptr ? replacement : lval;
        }
        Element replacement = doc.createElementNS(ptr.getNamespaceURI(), ptr.getTagName());
        NodeList nl = src.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            replacement.appendChild(doc.importNode(nl.item(i), true));
        }
        NamedNodeMap attrs = src.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String prefix;
            String attrValNs;
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().startsWith("xmlns")) continue;
            replacement.setAttributeNodeNS((Attr)doc.importNode(attrs.item(i), true));
            int colonIdx = attr.getValue().indexOf(":");
            if (colonIdx <= 0 || (attrValNs = src.lookupPrefix(prefix = attr.getValue().substring(0, colonIdx))) == null) continue;
            replacement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, attrValNs);
        }
        parent.replaceChild(replacement, ptr);
        DOMUtils.copyNSContext((Element)ptr, (Element)replacement);
        return lval == ptr ? replacement : lval;
    }

    private Element copyInto(Element lval, Element ptr, Element src) {
        ptr.appendChild(ptr.getOwnerDocument().importNode(src, true));
        return lval;
    }

    private Node replaceContent(Node lvalue, Node lvaluePtr, String rvalue) throws FaultException {
        Document d = lvaluePtr.getOwnerDocument();
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("lvaluePtr type " + lvaluePtr.getNodeType()));
            __log.debug((Object)("lvaluePtr " + DOMUtils.domToString((Node)lvaluePtr)));
            __log.debug((Object)("lvalue " + lvalue));
            __log.debug((Object)("rvalue " + rvalue));
        }
        switch (lvaluePtr.getNodeType()) {
            case 1: {
                while (lvaluePtr.hasChildNodes()) {
                    lvaluePtr.removeChild(lvaluePtr.getFirstChild());
                }
                lvaluePtr.appendChild(d.createTextNode(rvalue));
                if (!(lvalue instanceof Text)) break;
                lvalue = lvaluePtr.getFirstChild();
                break;
            }
            case 3: {
                Text newval = d.createTextNode(rvalue);
                lvaluePtr.getParentNode().replaceChild(newval, lvaluePtr);
                if (lvalue.getNodeType() == 1) {
                    if (lvalue.getFirstChild() == null) {
                        Text txt = lvalue.getOwnerDocument().createTextNode("");
                        lvalue.appendChild(txt);
                    }
                    if (lvalue.getFirstChild().getNodeType() == 3) {
                        lvalue = lvalue.getFirstChild();
                    }
                }
                if (lvalue.getNodeType() != 3 || !((Text)lvalue).getWholeText().equals(((Text)lvaluePtr).getWholeText())) break;
                lvalue = lvaluePtr = newval;
                break;
            }
            case 2: {
                ((Attr)lvaluePtr).setValue(rvalue);
                break;
            }
            default: {
                String msg = __msgs.msgInvalidLValue();
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(lvaluePtr + ": " + msg));
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSelectionFailure, msg);
            }
        }
        return lvalue;
    }

    private Node evalQuery(Node data, OMessageVarType.Part part, OExpression expression, EvaluationContext ec) throws FaultException {
        assert (data != null);
        if (part != null) {
            QName partName = new QName(null, part.name);
            Element qualLVal = DOMUtils.findChildByName((Element)((Element)data), (QName)partName);
            if (part.type instanceof OElementVarType) {
                QName elName = ((OElementVarType)part.type).elementType;
                qualLVal = DOMUtils.findChildByName((Element)qualLVal, (QName)elName);
            } else if (part.type == null) {
                if (qualLVal != null && qualLVal.getNodeType() == 1 && qualLVal.getAttribute("headerPart") != null && DOMUtils.getTextContent((Node)qualLVal) == null) {
                    qualLVal = DOMUtils.getFirstChildElement((Element)qualLVal);
                }
                if (qualLVal == null) {
                    qualLVal = data.getOwnerDocument().createElementNS(null, part.name);
                    qualLVal.setAttribute("headerPart", "true");
                    data.appendChild(qualLVal);
                }
            }
            data = qualLVal;
        }
        if (expression != null) {
            try {
                data = ec.evaluateQuery(data, expression);
            }
            catch (EvaluationException e) {
                String msg = __msgs.msgEvalException(expression.toString(), e.getMessage());
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)(expression + ": " + msg));
                }
                if (e.getCause() instanceof FaultException) {
                    throw (FaultException)e.getCause();
                }
                throw new FaultException(this.getOActivity().getOwner().constants.qnSubLanguageExecutionFault, msg);
            }
        }
        return data;
    }

    private class EvaluationContextProxy
    implements EvaluationContext {
        private OScope.Variable _var;
        private Node _varNode;
        private Node _rootNode;
        private EvaluationContext _ctx;

        private EvaluationContextProxy(OScope.Variable var, Node varNode) {
            this._var = var;
            this._varNode = varNode;
            this._ctx = AssignHelper.this.getEvaluationContext();
        }

        public Node readVariable(OScope.Variable variable, OMessageVarType.Part part) throws FaultException {
            if (variable.name.equals(this._var.name)) {
                if (part == null) {
                    return this._varNode;
                }
                return this._ctx.getPartData((Element)this._varNode, part);
            }
            return this._ctx.readVariable(variable, part);
        }

        public String readMessageProperty(OScope.Variable variable, OProcess.OProperty property) throws FaultException {
            return this._ctx.readMessageProperty(variable, property);
        }

        public boolean isLinkActive(OLink olink) throws FaultException {
            return this._ctx.isLinkActive(olink);
        }

        public Node getRootNode() {
            return this._rootNode;
        }

        public Node evaluateQuery(Node root, OExpression expr) throws FaultException {
            this._rootNode = root;
            try {
                return AssignHelper.this.getBpelRuntimeContext().getExpLangRuntime().evaluateNode(expr, this);
            }
            catch (EvaluationException e) {
                throw new InvalidProcessException("Expression Failed: " + expr, e);
            }
        }

        public Node getPartData(Element message, OMessageVarType.Part part) throws FaultException {
            return this._ctx.getPartData(message, part);
        }

        public Long getProcessId() {
            return this._ctx.getProcessId();
        }

        public boolean narrowTypes() {
            return false;
        }

        public URI getBaseResourceURI() {
            return this._ctx.getBaseResourceURI();
        }

        public Node getPropertyValue(QName propertyName) {
            return this._ctx.getPropertyValue(propertyName);
        }

        public QName getProcessQName() {
            return this._ctx.getProcessQName();
        }

        public Date getCurrentEventDateTime() {
            return Calendar.getInstance().getTime();
        }
    }
}

