/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import javax.xml.namespace.QName;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompilationMessageBundle;

public class CommonCompilationMessages
extends CompilationMessageBundle {
    public CompilationMessage infCompilingProcess() {
        return this.formatCompilationMessage("Compiling BPEL process.", new Object[0]);
    }

    public CompilationMessage errBpelParseErr() {
        return this.formatCompilationMessage("Error parsing BPEL process: the BPEL is either malformed or is invalid.", new Object[0]);
    }

    public CompilationMessage errCompilationErrors(int errorCount, String prettyErrors) {
        return this.formatCompilationMessage("Compilation completed with {0} error(s):\n{1}", errorCount, prettyErrors);
    }

    public CompilationMessage errUndeclaredLink(String linkName) {
        return this.formatCompilationMessage("Attempt to reference undeclared link \"{0}\".", linkName);
    }

    public CompilationMessage errInvalidImport(String importUri) {
        return this.formatCompilationMessage("The import \"{0}\" is invalid/malformed. */", importUri);
    }

    public CompilationMessage errWsdlImportFailed(String wsdlUri, String faultCode) {
        return this.formatCompilationMessage("Unable to import WSDL at URI \"{0}\"; WSDL fault code \"{1}\".", wsdlUri, faultCode);
    }

    public CompilationMessage errWsdlImportNotFound(String wsdlUri, String location) {
        return this.formatCompilationMessage("The WSDL for namespace \"{0}\" could not be found in \"{1}\".", wsdlUri, location);
    }

    public CompilationMessage errWsdlParseError(String faultCode, String location, String message) {
        return this.formatCompilationMessage("{1}: [{0}] {2}", faultCode, location, message);
    }

    public CompilationMessage errUnknownImportType(String importType) {
        return this.formatCompilationMessage("The import type \"{0}\" is unknown.", importType);
    }

    public CompilationMessage errUnspecifiedImportType() {
        return this.formatCompilationMessage("Must specify an import type.", new Object[0]);
    }

    public CompilationMessage errMissingImportLocation() {
        return this.formatCompilationMessage("Missing import location.", new Object[0]);
    }

    public CompilationMessage errUndeclaredProperty(QName propertyName) {
        return this.formatCompilationMessage("Attempt to reference undeclared property \"{0}\".", propertyName);
    }

    public CompilationMessage errUndeclaredVariable(String varName) {
        return this.formatCompilationMessage("Attempt to reference undeclared variable \"{0}\".", varName);
    }

    public CompilationMessage errUndeclaredCorrelationSet(String csetName) {
        return this.formatCompilationMessage("Attempt to reference undeclared correlation set \"{0}\".", csetName);
    }

    public CompilationMessage errDuplicateUseCorrelationSet(String csetName) {
        return this.formatCompilationMessage("Attempt to use a correlation set \"{0}\" more than once for a set of correlations.", csetName);
    }

    public CompilationMessage errMessageVariableRequired(String variableName) {
        return this.formatCompilationMessage("Cannot use non-message variable \"{0}\" in this context (message variable is required).", variableName);
    }

    public CompilationMessage errPropertyDeclaredWithComplexType(QName propertyName, QName complexType) {
        return this.formatCompilationMessage("Attempt to declare property \"{0}\" with complex type \"{1}\".", propertyName, complexType);
    }

    public CompilationMessage errDuplicateLinkTarget(String linkName) {
        return this.formatCompilationMessage("Duplicate declaration of target for link \"{0}\".", linkName);
    }

    public CompilationMessage errDuplicateLinkSource(String linkName) {
        return this.formatCompilationMessage("Duplicate declaration of source for link \"{0}\".", linkName);
    }

    public CompilationMessage errDuplicatePartnerLinkDecl(String partnerLinkName) {
        return this.formatCompilationMessage("Duplicate declaration of partnerLink \"{0}\".", partnerLinkName);
    }

    public CompilationMessage errVariableDeclMissingType(String varName) {
        return this.formatCompilationMessage("Declaration of variable \"{0}\" does not specify the required type (either MessageType or ElementType).", varName);
    }

    public CompilationMessage errVariableDeclInvalid(String variable) {
        return this.formatCompilationMessage("Declaration of variable \"{0}\" specifies  both a MessageType and an ElementType.", variable);
    }

    public CompilationMessage errVariableDeclMutipleTypes(String varName) {
        return this.formatCompilationMessage("Declaration of variable \"{0}\" can specify either MessageType or ElementType, but not both.", varName);
    }

    public CompilationMessage errDuplicateVariableDecl(String varName) {
        return this.formatCompilationMessage("Duplicate declaration of variable \"{0}\".", varName);
    }

    public CompilationMessage errUnknownActivity(String className) {
        return this.formatCompilationMessage("The BOM activity class \"{0}\" is unrecoginized.", className);
    }

    public CompilationMessage errNoRootActivity() {
        return this.formatCompilationMessage("Process has no root activity.", new Object[0]);
    }

    public CompilationMessage errUnknownExpressionLanguage(String expressionLanguage) {
        return this.formatCompilationMessage("The expression language \"{0}\" is unrecognized.", expressionLanguage);
    }

    public CompilationMessage errNoWsdlDefinitionForNamespace(String namespaceURI) {
        return this.formatCompilationMessage("No WSDL definition for namespace \"{0}\".", namespaceURI);
    }

    public CompilationMessage errUndeclaredMessage(String msgName, String namespaceURI) {
        return this.formatCompilationMessage("Attempt to reference undeclared WSDL message \"{0}\" in namespace {1}.", msgName, namespaceURI);
    }

    public CompilationMessage errAliasUndeclaredMessage(QName property, String path) {
        return this.formatCompilationMessage("Missing message type reference in property alias for property {0} using path {1}.", property.toString(), path);
    }

    public CompilationMessage errUndeclaredPropertyAlias(String messageType, QName propertyName) {
        return this.formatCompilationMessage("The property \"{1}\" does not have an alias for message type \"{0}\".", messageType, propertyName);
    }

    public CompilationMessage errUndeclaredPartnerLink(String plinkName) {
        return this.formatCompilationMessage("Attempt to reference undeclared partner link \"{0}\".", plinkName);
    }

    public CompilationMessage errUndeclaredPartnerLinkType(QName partnerLinkType) {
        return this.formatCompilationMessage("Attempt to reference undeclared partner link type \"{0}\".", partnerLinkType);
    }

    public CompilationMessage errUndeclaredRole(String roleName, QName partnerLinkTypeName) {
        return this.formatCompilationMessage("Attempt to reference undeclared role \"{0}\" for partnerLink \"{1}\".", roleName, partnerLinkTypeName);
    }

    public CompilationMessage errUndeclaredPortType(QName portType) {
        return this.formatCompilationMessage("Attempt to reference undeclared portType \"{0}\".", portType);
    }

    public CompilationMessage errUndeclaredMessagePart(String varName, QName messageType, String partName) {
        return this.formatCompilationMessage("Attempt to reference undeclared part \"{2}\" for variable \"{0}\": the WSDL message type \"{1}\" does not declare \"{2}\".", varName, messageType, partName);
    }

    public CompilationMessage errPartnerLinkDoesNotDeclareMyRole(String partnerLinkName) {
        return this.formatCompilationMessage("The partnerLink \"{0}\" does not define a myRole.", partnerLinkName);
    }

    public CompilationMessage errPartnerLinkDoesNotDeclarePartnerRole(String partnerLinkName) {
        return this.formatCompilationMessage("The partnerLink \"{0}\" does not define a partnerRole.", partnerLinkName);
    }

    public CompilationMessage errPartnerLinkNoPartnerRoleButInitialize(String partnerLinkName) {
        return this.formatCompilationMessage("The partnerLink \"{0}\" does not define a partnerRole but is set to initializePartnerRole=yes.", partnerLinkName);
    }

    public CompilationMessage errUndeclaredOperation(QName portType, String operationName) {
        return this.formatCompilationMessage("The operation \"{1}\" is not declared on portType \"{0}\".", portType, operationName);
    }

    public CompilationMessage errVariableTypeMismatch(String varName, QName expectedType, QName actualType) {
        return this.formatCompilationMessage("The variable \"{0}\" must be of type \"{1}\" to be used in this context; its actual type is \"{2}\".", varName, expectedType, actualType);
    }

    public CompilationMessage errPortTypeMismatch(QName portType, QName expectedPortType) {
        return this.formatCompilationMessage("The port type \"{0}\" does not match the expected port type (\"{1}\").", portType, expectedPortType);
    }

    public CompilationMessage errUseOfUninitializedCorrelationSet(String correlationSet) {
        return this.formatCompilationMessage("Attempt to use correlation set \"{0}\" before it has been initialized.", correlationSet);
    }

    public CompilationMessage errTwoWayOperationExpected(String opname) {
        return this.formatCompilationMessage("Attempt to use one-way operation \"{0}\" in a context requiring a request-response.", new Object[0]);
    }

    public CompilationMessage errMissingQueryExpression() {
        return this.formatCompilationMessage("A required query language expression was not present.", new Object[0]);
    }

    public CompilationMessage errCompensateNAtoContext() {
        return this.formatCompilationMessage("Compensation is not applicable in this (non-recovery) context.", new Object[0]);
    }

    public CompilationMessage errCompensateOfInvalidScope(String scopeToCompensate) {
        return this.formatCompilationMessage("The scope \"{0}\" is not available for compensation in this context.", scopeToCompensate);
    }

    public CompilationMessage errUnrecognizedBpelVersion() {
        return this.formatCompilationMessage("Unrecognized BPEL version!", new Object[0]);
    }

    public CompilationMessage errUndeclaredXsdType(QName typeName) {
        return this.formatCompilationMessage("Attempt to reference undeclared XSD type \"{0}\".", typeName);
    }

    public CompilationMessage errUnrecognizedVariableDeclaration(String varName) {
        return this.formatCompilationMessage("The declaration of variable \"{0}\" was not recognized.", varName);
    }

    public CompilationMessage errTODO(String description) {
        return this.formatCompilationMessage("FEATURE NOT SUPPORTED: {0}", new Object[0]);
    }

    public CompilationMessage errBpel11RequiresWsdl() {
        return this.formatCompilationMessage("A WSDL document must be specified for a BPEL4WS 1.1 process.", new Object[0]);
    }

    public CompilationMessage errLinkCrossesEventHandlerBoundary(String linkName) {
        return this.formatCompilationMessage("The link \"{0}\" crosses an event handler boundary.", new Object[0]);
    }

    public CompilationMessage errInvalidAlarm() {
        return this.formatCompilationMessage("Invalid alarm handler (check for/until/repeatEvery or child activity).", new Object[0]);
    }

    public CompilationMessage errInvalidEvent() {
        return this.formatCompilationMessage("Invalid event handler (no child activity?).", new Object[0]);
    }

    public CompilationMessage warnWsdlUriIgnoredFor20Process() {
        return this.formatCompilationMessage("Process WSDL URI is ignored for WS-BPEL 2.0 processes.", new Object[0]);
    }

    public CompilationMessage errDuplicateWSDLImport(String tns, String location) {
        return this.formatCompilationMessage("Attempted to import WSDL for namespace {0} from multiple locations: definitions from {1} will be ignored!", tns, location);
    }

    public CompilationMessage errSchemaError(String detailMessage) {
        return this.formatCompilationMessage("Error in schema processing: {0}", detailMessage);
    }

    public CompilationMessage errInvalidDocXsltUri(String docStrUri) {
        return this.formatCompilationMessage("XSLT stylesheet URI is invalid/malformed: {0}", docStrUri);
    }

    public CompilationMessage errCantFindXslt(String docStrUri) {
        return this.formatCompilationMessage("Could not find the XSLT stylesheet referenced with URI {0}, make sure it has been properly provided to the compiler.", docStrUri);
    }

    public CompilationMessage errNoMyRoleOnReceivePartnerLink(String plink) {
        return this.formatCompilationMessage("Partner link {0} used in receive activity doesn't define role myRole.", plink);
    }

    public CompilationMessage errInvalidDeploymentDescriptor(String message) {
        return this.formatCompilationMessage("Deployment descriptor is invalid: {0}", message);
    }

    public CompilationMessage errInvalidRetryForValue(String message) {
        return this.formatCompilationMessage("The retryFor attribute must be a positive integer, found {0}", message);
    }

    public CompilationMessage errInvalidRetryDelayValue(String message) {
        return this.formatCompilationMessage("The retryDelay attribute must be a positive integer, found {0}", message);
    }

    public CompilationMessage errAtomicScopeNesting(boolean atomic) {
        if (atomic) {
            return this.formatCompilationMessage("Cannot nest atomic scopes inside each other.", new Object[0]);
        }
        return this.formatCompilationMessage("A scope enclosed inside an atomic scope cannot declare itself as not atomic", new Object[0]);
    }

    public CompilationMessage errProcessNameNotSpecified() {
        return this.formatCompilationMessage("The process name was not specified.", new Object[0]);
    }

    public CompilationMessage errProcessNamespaceNotSpecified() {
        return this.formatCompilationMessage("The process namespace was not specified.", new Object[0]);
    }

    public CompilationMessage errMissingMyRolePortType(QName portType, String myRole, QName plnkType) {
        return this.formatCompilationMessage("Missing portType {0} on partnerLinkType {1} for myRole {2}", portType, plnkType, myRole);
    }

    public CompilationMessage errMissingPartnerRolePortType(QName portType, String partnerRole, QName plnkType) {
        return this.formatCompilationMessage("Missing portType {0} on partnerLinkType {1} for partnerRole {2}", portType, plnkType, partnerRole);
    }

    public CompilationMessage errUnknownPartInAlias(String part, String message) {
        return this.formatCompilationMessage("The part {0} declared in property alias for messageType {1} couldn't be found.", part, message);
    }

    public CompilationMessage errEmptyScope() {
        return this.formatCompilationMessage("Empty scopes are forbidden.", new Object[0]);
    }

    public CompilationMessage errEmptyCatch() {
        return this.formatCompilationMessage("Empty catch faut handlers are forbidden.", new Object[0]);
    }

    public CompilationMessage errMustSpecifyRelatedVariable(String name) {
        return this.formatCompilationMessage("The external variable declaration for \"{0}\" must specify a related variable.", name);
    }

    public CompilationMessage errMustSpecifyExternalVariableId(String name) {
        return this.formatCompilationMessage("The external variable declaration for \"{0}\" must specify an external variable identifier.", name);
    }

    public CompilationMessage errEmptySequence() {
        return this.formatCompilationMessage("Empty sequences are forbidden.", new Object[0]);
    }
}

