/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.sap.model.v2;

import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.sap.model.QIDocDestinationModel;
import org.switchyard.component.camel.sap.model.v2.V2IDocDestinationModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V2QIDocDestinationModel
extends V2IDocDestinationModel
implements QIDocDestinationModel {
    public V2QIDocDestinationModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    public V2QIDocDestinationModel(String namespace, String name) {
        super(namespace, name);
        this.setModelChildrenOrder(new String[]{"destinationName", "queueName", "idocType", "idocTypeExtension", "systemRelease", "applicationRelease"});
    }

    @Override
    public String getQueueName() {
        return this.getConfig("queueName");
    }

    @Override
    public QIDocDestinationModel setQueueName(String queue) {
        this.setConfig("queueName", queue);
        return this;
    }

    @Override
    public StringBuilder createBaseURIString(QueryString queryString) {
        StringBuilder buf = new StringBuilder(this.getSchema()).append(':').append(this.getDestinationName()).append(':').append(this.getQueueName()).append(':').append(this.getIdocType());
        String idocTypeExt = this.getIdocTypeExtension();
        if (idocTypeExt != null && !idocTypeExt.isEmpty()) {
            buf.append(':').append(idocTypeExt);
            String sysRel = this.getSystemRelease();
            if (sysRel != null && !sysRel.isEmpty()) {
                buf.append(':').append(sysRel);
                String appRel = this.getApplicationRelease();
                if (appRel != null && !appRel.isEmpty()) {
                    buf.append(':').append(appRel);
                }
            }
        }
        return buf;
    }
}

