/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.Reference;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemListReferences
implements OperationStepHandler {
    public static final SwitchYardSubsystemListReferences INSTANCE = new SwitchYardSubsystemListReferences();

    private SwitchYardSubsystemListReferences() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode references = context.getResult();
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("application-name")) {
                    QName applicationName = QName.valueOf(operation.get("application-name").asString());
                    Application application = switchYard.getApplication(applicationName);
                    if (application != null) {
                        for (Reference reference : application.getReferences()) {
                            references.add(ModelNodeCreationUtil.createSimpleReferenceNode(reference));
                        }
                    }
                } else {
                    for (Reference reference : switchYard.getReferences()) {
                        references.add(ModelNodeCreationUtil.createSimpleReferenceNode(reference));
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

