/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import javax.xml.namespace.QName;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.admin.ModelNodeCreationUtil;
import org.switchyard.as7.extension.services.SwitchYardAdminService;

public final class SwitchYardSubsystemShowMetrics
implements OperationStepHandler {
    public static final SwitchYardSubsystemShowMetrics INSTANCE = new SwitchYardSubsystemShowMetrics();

    private SwitchYardSubsystemShowMetrics() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                if (operation.hasDefined("service-name")) {
                    String serviceName = operation.get("service-name").asString();
                    String type = operation.get("type").asString();
                    QName serviceQName = QName.valueOf(serviceName);
                    for (Application application : switchYard.getApplications()) {
                        if (type == null || "*".equals(type) || "service".equals(type)) {
                            for (Service service : application.getServices()) {
                                if (!"*".equals(serviceName) && !serviceQName.equals(service.getName())) continue;
                                context.getResult().add(ModelNodeCreationUtil.createServiceMetricsNode(service));
                            }
                        }
                        if (type == null || "*".equals(type) || "reference".equals(type)) {
                            for (Reference reference : application.getReferences()) {
                                if (!"*".equals(serviceName) && !serviceQName.equals(reference.getName())) continue;
                                context.getResult().add(ModelNodeCreationUtil.createReferenceMetricsNode(reference));
                            }
                        }
                        if (type != null && !"*".equals(type) && !"componentService".equals(type)) continue;
                        for (ComponentService componentService : application.getComponentServices()) {
                            if (!"*".equals(serviceName) && !serviceQName.equals(componentService.getName())) continue;
                            context.getResult().add(ModelNodeCreationUtil.createComponentServiceMetricsNode(componentService));
                        }
                    }
                } else {
                    context.getResult().add(ModelNodeCreationUtil.addMetricsToNode(new ModelNode(), switchYard.getMessageMetrics()));
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

