/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;

public class SwitchYardDependencyProcessor
implements DeploymentUnitProcessor {
    private static final PathFilter META_INF_FILTER = PathFilters.isChildOf((String)"META-INF");
    private static final ModuleIdentifier SWITCHYARD_ID = ModuleIdentifier.create((String)"org.switchyard");
    private static final ModuleIdentifier SWITCHYARD_API_ID = ModuleIdentifier.create((String)"org.switchyard.api");
    private static final ModuleIdentifier SWITCHYARD_COMMON_ID = ModuleIdentifier.create((String)"org.switchyard.common");
    private static final ModuleIdentifier SWITCHYARD_COMMON_CAMEL_ID = ModuleIdentifier.create((String)"org.switchyard.common.camel");
    private static final ModuleIdentifier SWITCHYARD_BUS_CAMEL = ModuleIdentifier.create((String)"org.switchyard.bus.camel");
    private static final ModuleIdentifier SWITCHYARD_CONFIG_ID = ModuleIdentifier.create((String)"org.switchyard.config");
    private static final ModuleIdentifier SWITCHYARD_RUNTIME_ID = ModuleIdentifier.create((String)"org.switchyard.runtime");
    private static final ModuleIdentifier SWITCHYARD_TRANSFORM_ID = ModuleIdentifier.create((String)"org.switchyard.transform");
    private static final ModuleIdentifier SWITCHYARD_VALIDATE_ID = ModuleIdentifier.create((String)"org.switchyard.validate");
    private static final ModuleIdentifier DELTASPIKE_ID = ModuleIdentifier.create((String)"org.apache.deltaspike.core.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SWITCHYARD_ID, false, false, true, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SWITCHYARD_API_ID, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SWITCHYARD_COMMON_ID, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, DELTASPIKE_ID, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SWITCHYARD_BUS_CAMEL, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SWITCHYARD_COMMON_CAMEL_ID, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, SWITCHYARD_CONFIG_ID, false, false, false, false));
        ModuleDependency dep = new ModuleDependency(moduleLoader, SWITCHYARD_RUNTIME_ID, false, false, true, false);
        dep.addImportFilter(META_INF_FILTER, true);
        moduleSpecification.addSystemDependency(dep);
        dep = new ModuleDependency(moduleLoader, SWITCHYARD_TRANSFORM_ID, false, false, true, false);
        dep.addImportFilter(META_INF_FILTER, true);
        moduleSpecification.addSystemDependency(dep);
        dep = new ModuleDependency(moduleLoader, SWITCHYARD_VALIDATE_ID, false, false, true, false);
        dep.addImportFilter(META_INF_FILTER, true);
        moduleSpecification.addSystemDependency(dep);
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

