/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.ws;

import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.webservices.publish.EndpointPublisherImpl;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.logging.Logger;
import org.jboss.metadata.parser.jbossweb.JBossWebMetaDataParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;
import org.jboss.wsf.spi.publish.EndpointPublisherFactory;
import org.jboss.wsf.spi.security.SecurityDomainContext;
import org.switchyard.ServiceDomain;
import org.switchyard.as7.extension.ws.Interceptors;
import org.switchyard.as7.extension.ws.SwitchYardSecurityDomainContext;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.WebServicePublishException;
import org.switchyard.component.soap.config.model.EndpointConfigModel;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.BaseWebService;

public class JBossWSEndpoint
implements org.switchyard.component.common.Endpoint {
    private static final Logger LOGGER = Logger.getLogger((String)"org.switchyard");
    private static final String HOST = "default-host";
    private static final EndpointPublisherFactory FACTORY;
    private EndpointPublisher _publisher;
    private Context _context;

    public JBossWSEndpoint() throws Exception {
        this._publisher = FACTORY.newEndpointPublisher(HOST);
    }

    public JBossWSEndpoint(String host) throws Exception {
        this._publisher = FACTORY.newEndpointPublisher(host);
    }

    public void publish(ServiceDomain domain, String contextRoot, Map<String, String> urlPatternToClassNameMap, WebservicesMetaData wsMetadata, SOAPBindingModel bindingModel, InboundHandler handler) throws Exception {
        JBossWebMetaData jbwMetadata;
        ClassLoader deploymentClassLoader = (ClassLoader)domain.getProperty("org.switchyard.deployment.DeploymentClassLoader");
        EndpointConfigModel epcModel = bindingModel.getEndpointConfig();
        JBossWebservicesMetaData jbwsMetadata = null;
        if (epcModel != null) {
            String configName = epcModel.getConfigName();
            String configFile = epcModel.getConfigFile();
            if (configFile != null) {
                URL jbwsURL = Classes.getResource((String)configFile, (ClassLoader[])new ClassLoader[]{deploymentClassLoader, this.getClass().getClassLoader()});
                try {
                    JBossWebservicesFactory factory = new JBossWebservicesFactory(jbwsURL);
                    jbwsMetadata = factory.load(jbwsURL);
                }
                catch (WebServiceException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error((Object)"Unable to load jboss-webservices metadata", (Throwable)e);
                    }
                    jbwsMetadata = new JBossWebservicesMetaData("/", configName, configFile, jbwsURL, null, null, null);
                }
            }
        }
        ClassLoader tccl = Classes.getTCCL();
        if (this._publisher instanceof EndpointPublisherImpl && (jbwMetadata = this.getJBossWebMetaData(deploymentClassLoader)) != null) {
            EndpointPublisherImpl pubImpl = (EndpointPublisherImpl)this._publisher;
            ServiceContainer baseTarget = this.currentServiceContainer().getService(WSServices.CONFIG_SERVICE).getServiceContainer();
            this._context = pubImpl.publish((ServiceTarget)baseTarget, contextRoot, tccl, urlPatternToClassNameMap, jbwMetadata, wsMetadata, jbwsMetadata);
        }
        if (this._context == null) {
            this._context = this._publisher.publish(contextRoot, tccl, urlPatternToClassNameMap, wsMetadata, jbwsMetadata);
        }
        for (Endpoint ep : this._context.getEndpoints()) {
            BaseWebService wsProvider = (BaseWebService)ep.getInstanceProvider().getInstance(BaseWebService.class.getName()).getValue();
            wsProvider.setInvocationClassLoader(tccl);
            wsProvider.setConsumer(handler);
            Interceptors.addInterceptors(ep, bindingModel, tccl);
            ep.setSecurityDomainContext((SecurityDomainContext)new SwitchYardSecurityDomainContext(domain.getServiceSecurity(bindingModel.getService().getComponentService().getSecurity()).getSecurityDomain(), ep.getSecurityDomainContext()));
        }
    }

    private JBossWebMetaData getJBossWebMetaData(ClassLoader deploymentClassLoader) {
        JBossWebMetaData jbwMetadata;
        block7: {
            jbwMetadata = null;
            InputStream is = null;
            try {
                URL jbwURL = Classes.getResource((String)"WEB-INF/jboss-web.xml", (ClassLoader[])new ClassLoader[]{deploymentClassLoader, this.getClass().getClassLoader()});
                if (jbwURL == null) {
                    jbwURL = Classes.getResource((String)"META-INF/jboss-web.xml", (ClassLoader[])new ClassLoader[]{deploymentClassLoader, this.getClass().getClassLoader()});
                }
                if (jbwURL != null) {
                    is = jbwURL.openStream();
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    inputFactory.setXMLResolver(NoopXMLResolver.create());
                    XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                    jbwMetadata = JBossWebMetaDataParser.parse((XMLStreamReader)xmlReader, (PropertyReplacer)PropertyReplacers.noop());
                }
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error((Object)"Unable to load jboss-web metadata", (Throwable)e);
                }
                if (is == null) break block7;
                try {
                    is.close();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
        }
        return jbwMetadata;
    }

    private ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }

    public void start() {
    }

    public void stop() {
        if (this._context != null && this._publisher != null) {
            try {
                this._publisher.destroy(this._context);
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
        }
    }

    static {
        try {
            ClassLoader loader = ClassLoaderProvider.getDefaultProvider().getWebServiceSubsystemClassLoader();
            FACTORY = ServiceLoader.load(EndpointPublisherFactory.class, loader).iterator().next();
        }
        catch (Exception e) {
            throw new WebServicePublishException((Throwable)e);
        }
    }
}

