/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.policy.Policy;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.policy.TransactionPolicy;

public final class PolicyFactory {
    private static Set<Policy> _policies = new HashSet<Policy>();

    private PolicyFactory() {
    }

    @Deprecated
    public static Policy getPolicy(String name) throws Exception {
        return PolicyFactory.getPolicy(new QName(name));
    }

    public static Policy getPolicy(final QName qname) throws Exception {
        for (Policy p : _policies) {
            if (p.getQName().equals(qname)) {
                return p;
            }
            if (!"".equals(qname.getNamespaceURI()) || !qname.getLocalPart().equals(p.getQName().getLocalPart())) continue;
            return p;
        }
        return new Policy(){

            @Override
            public QName getQName() {
                return qname;
            }

            @Override
            public String getName() {
                return this.getQName().getLocalPart();
            }

            public String toString() {
                return this.getQName().toString();
            }

            @Override
            public boolean supports(Policy.PolicyType type) {
                return true;
            }

            @Override
            public boolean isCompatibleWith(Policy target) {
                return true;
            }

            @Override
            public Policy getPolicyDependency() {
                return null;
            }
        };
    }

    public static Set<Policy> getAllAvailablePolicies() {
        return Collections.unmodifiableSet(_policies);
    }

    public static Set<Policy> getAvailableInteractionPolicies() {
        HashSet<Policy> interactions = new HashSet<Policy>();
        for (Policy p : _policies) {
            if (!p.supports(Policy.PolicyType.INTERACTION)) continue;
            interactions.add(p);
        }
        return Collections.unmodifiableSet(interactions);
    }

    public static Set<Policy> getAvailableImplementationPolicies() {
        HashSet<Policy> implementations = new HashSet<Policy>();
        for (Policy p : _policies) {
            if (!p.supports(Policy.PolicyType.IMPLEMENTATION)) continue;
            implementations.add(p);
        }
        return Collections.unmodifiableSet(implementations);
    }

    static {
        _policies.addAll(Arrays.asList(TransactionPolicy.values()));
        _policies.addAll(Arrays.asList(SecurityPolicy.values()));
    }
}

