/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingType;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceProvider;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.InboundHandler;

@WebServiceProvider
@ServiceMode(value=Service.Mode.MESSAGE)
@BindingType(value="http://www.w3.org/2003/05/soap/bindings/HTTP/")
public class BaseWebService
implements Provider<SOAPMessage> {
    private static String ACTION_EQUALS = "action=";
    private static String CONTENT_TYPE_L = "Content-type";
    private static String CONTENT_TYPE = "Content-Type";
    private InboundHandler _serviceConsumer;
    private ClassLoader _invocationClassLoader;
    @Resource
    private WebServiceContext _wsContext;

    public void setConsumer(InboundHandler serviceConsumer) {
        this._serviceConsumer = serviceConsumer;
    }

    public void setInvocationClassLoader(ClassLoader classLoader) {
        this._invocationClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage invoke(SOAPMessage request) {
        String mimeContentType;
        MimeHeaders mimeHeaders;
        String[] mimeContentTypes;
        if (request != null && (mimeContentTypes = (mimeHeaders = request.getMimeHeaders()).getHeader(CONTENT_TYPE)) != null && (mimeContentType = mimeContentTypes[0]) != null && mimeContentType.indexOf(ACTION_EQUALS) == -1) {
            int idx;
            Map headers = (Map)this._wsContext.getMessageContext().get((Object)"javax.xml.ws.http.request.headers");
            List contentTypes = (List)headers.get(CONTENT_TYPE_L);
            if (contentTypes == null || contentTypes.size() == 0) {
                contentTypes = (List)headers.get(CONTENT_TYPE);
            }
            if (contentTypes != null && contentTypes.size() > 0 && (idx = ((String)contentTypes.get(0)).indexOf(ACTION_EQUALS)) > 0) {
                String action = ((String)contentTypes.get(0)).substring(idx + 7).replace("\"\"", "\"");
                mimeHeaders.setHeader(CONTENT_TYPE, mimeContentType + "; " + ACTION_EQUALS + action);
            }
        }
        SOAPMessage response = null;
        ClassLoader original = Classes.setTCCL((ClassLoader)this._invocationClassLoader);
        try {
            response = this._serviceConsumer.invoke(request, this._wsContext);
        }
        finally {
            Classes.setTCCL((ClassLoader)original);
        }
        return response;
    }
}

