/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.edisax.BufferedSegmentListener;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedSegmentReader {
    private static final int MAX_MARK_READ = 512;
    private static Log logger = LogFactory.getLog(BufferedSegmentReader.class);
    public static String IGNORE_CR_LF = "!$";
    private InputStream underlyingByteStream;
    private boolean marked = false;
    private Charset readEncoding;
    private Reader reader;
    private StringBuffer segmentBuffer = new StringBuffer(512);
    private String[] currentSegmentFields = null;
    private int currentSegmentNumber = 0;
    private Stack<Delimiters> delimitersStack = new Stack();
    private Delimiters currentDelimiters;
    private BufferedSegmentListener segmentListener;
    private boolean ignoreNewLines;
    private int charReadCount = 0;

    public BufferedSegmentReader(InputSource ediInputSource, Delimiters rootDelimiters) {
        this.underlyingByteStream = ediInputSource.getByteStream();
        this.reader = ediInputSource.getCharacterStream();
        if (this.reader == null) {
            this.readEncoding = Charset.defaultCharset();
            this.reader = new InputStreamReader(this.underlyingByteStream, this.readEncoding);
        } else if (this.reader instanceof InputStreamReader) {
            this.readEncoding = Charset.forName(((InputStreamReader)this.reader).getEncoding());
        }
        this.currentDelimiters = rootDelimiters;
    }

    public void mark() {
        if (this.underlyingByteStream != null) {
            if (this.underlyingByteStream.markSupported()) {
                this.underlyingByteStream.mark(512);
                this.marked = true;
            } else {
                logger.debug((Object)("Unable to mark EDI Reader for rest (to change reader encoding).  Underlying InputStream type '" + this.underlyingByteStream.getClass().getName() + "' does not support mark."));
            }
        } else {
            logger.debug((Object)"Unable to mark EDI Reader for rest (to change reader encoding).  BufferedSegmentReader instance does not have access to the underlying InputStream.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset changeEncoding(Charset encoding) throws IOException {
        if (this.underlyingByteStream == null) {
            throw new IllegalStateException("Unable to change stream read encoding to '" + encoding + "'.  BufferedSegmentReader does not have access to the underlying stream.");
        }
        if (this.readEncoding != null && encoding.equals(this.readEncoding)) {
            return this.readEncoding;
        }
        if (!this.underlyingByteStream.markSupported()) {
            logger.debug((Object)"Unable to to change stream read encoding on a stream that does not support 'mark'.");
            return this.readEncoding;
        }
        if (!this.marked) {
            logger.debug((Object)"Unable to to change stream read encoding on a stream.  'mark' was not called, or was called and failed.");
            return this.readEncoding;
        }
        try {
            this.underlyingByteStream.reset();
            this.marked = false;
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to to change stream read encoding on stream because reset failed.  Probably because the mark has been invalidated after reading more than 512 bytes from the stream.", (Throwable)e);
            return this.readEncoding;
        }
        this.reader = new InputStreamReader(this.underlyingByteStream, encoding);
        this.underlyingByteStream.skip(this.charReadCount);
        try {
            Charset charset = this.readEncoding;
            return charset;
        }
        finally {
            this.readEncoding = encoding;
        }
    }

    public Delimiters getDelimiters() {
        return this.currentDelimiters;
    }

    public void pushDelimiters(Delimiters delimiters) {
        this.delimitersStack.push(this.currentDelimiters);
        this.currentDelimiters = delimiters;
    }

    public void popDelimiters() {
        this.currentDelimiters = this.delimitersStack.pop();
    }

    public Stack<Delimiters> getDelimitersStack() {
        return this.delimitersStack;
    }

    public void setIgnoreNewLines(boolean ignoreNewLines) {
        this.ignoreNewLines = ignoreNewLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(int numChars) throws IOException {
        this.segmentBuffer.setLength(0);
        try {
            String string = this.peek(numChars);
            return string;
        }
        finally {
            this.segmentBuffer.setLength(0);
        }
    }

    public String peek(int numChars) throws IOException {
        return this.peek(numChars, false);
    }

    public String peek(int numChars, boolean ignoreLeadingWhitespace) throws IOException {
        boolean ignoreCRLF;
        boolean bl = ignoreCRLF = this.currentDelimiters.ignoreCRLF() || this.ignoreNewLines;
        if (this.segmentBuffer.length() < numChars) {
            int c = ignoreLeadingWhitespace ? this.forwardPastWhitespace() : this.readChar();
            while (c != -1) {
                if (ignoreCRLF && (c == 10 || c == 13)) {
                    c = this.readChar();
                    continue;
                }
                this.segmentBuffer.append((char)c);
                if (this.segmentBuffer.length() == numChars) break;
                c = this.readChar();
            }
        }
        int endIndex = Math.min(numChars, this.segmentBuffer.length());
        return this.segmentBuffer.substring(0, endIndex);
    }

    public void setSegmentListener(BufferedSegmentListener segmentListener) {
        this.segmentListener = segmentListener;
    }

    public boolean moveToNextSegment() throws IOException {
        return this.moveToNextSegment(true);
    }

    public boolean moveToNextSegment(boolean clearBuffer) throws IOException {
        boolean ignoreCRLF;
        char[] segmentDelimiter = this.currentDelimiters.getSegmentDelimiter();
        int delimiterLen = segmentDelimiter.length;
        String escape = this.currentDelimiters.getEscape();
        int escapeLen = escape != null ? escape.length() : 0;
        int c = this.readChar();
        boolean bl = ignoreCRLF = this.currentDelimiters.ignoreCRLF() || this.ignoreNewLines;
        if (clearBuffer) {
            this.segmentBuffer.setLength(0);
        }
        this.currentSegmentFields = null;
        if (c == -1) {
            return false;
        }
        c = this.forwardPastWhitespace(c);
        while (c != -1) {
            char theChar = (char)c;
            if (ignoreCRLF && (theChar == '\n' || theChar == '\r')) {
                c = this.readChar();
                continue;
            }
            this.segmentBuffer.append((char)c);
            int segLen = this.segmentBuffer.length();
            if (segLen >= delimiterLen) {
                boolean reachedSegEnd = true;
                for (int i = 0; i < delimiterLen; ++i) {
                    String precedingEscapeString;
                    char delimChar;
                    char segChar = this.segmentBuffer.charAt(segLen - 1 - i);
                    if (segChar != (delimChar = segmentDelimiter[delimiterLen - 1 - i])) {
                        reachedSegEnd = false;
                        break;
                    }
                    int escapeIndex = segLen - 1 - i - escapeLen;
                    if (escapeIndex <= -1 || escape == null) continue;
                    String escapeString = this.segmentBuffer.substring(escapeIndex, escapeIndex + escapeLen);
                    String string = precedingEscapeString = escapeIndex - escapeLen > -1 ? this.segmentBuffer.substring(escapeIndex - escapeLen, escapeIndex) : "";
                    if (!escape.equals(escapeString) || escape.equals(precedingEscapeString)) continue;
                    this.segmentBuffer = this.segmentBuffer.delete(escapeIndex, escapeIndex + escapeLen);
                    reachedSegEnd = false;
                    break;
                }
                if (reachedSegEnd) {
                    this.segmentBuffer.setLength(segLen - delimiterLen);
                    break;
                }
            }
            c = this.readChar();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.segmentBuffer.toString());
        }
        ++this.currentSegmentNumber;
        if (this.segmentListener != null) {
            return this.segmentListener.onSegment(this);
        }
        return true;
    }

    public boolean hasCurrentSegment() {
        if (this.segmentListener != null) {
            return this.segmentListener.onSegment(this);
        }
        return this.segmentBuffer.length() != 0;
    }

    public StringBuffer getSegmentBuffer() {
        return this.segmentBuffer;
    }

    public String[] getCurrentSegmentFields() throws IllegalStateException {
        this.assertCurrentSegmentExists();
        if (this.currentSegmentFields == null) {
            int endIndex;
            this.currentSegmentFields = EDIUtils.split(this.segmentBuffer.toString(), this.currentDelimiters.getField(), this.currentDelimiters.getEscape());
            if (this.currentDelimiters.getSegment().equals("\n") && this.currentSegmentFields[endIndex = this.currentSegmentFields.length - 1].endsWith("\r")) {
                int stringLen = this.currentSegmentFields[endIndex].length();
                this.currentSegmentFields[endIndex] = this.currentSegmentFields[endIndex].substring(0, stringLen - 1);
            }
        }
        return this.currentSegmentFields;
    }

    public int getCurrentSegmentNumber() {
        return this.currentSegmentNumber;
    }

    private int forwardPastWhitespace() throws IOException {
        return this.forwardPastWhitespace(this.readChar());
    }

    private int forwardPastWhitespace(int c) throws IOException {
        while (c != -1 && Character.isWhitespace((char)c)) {
            c = this.readChar();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readChar() throws IOException {
        try {
            int n = this.reader.read();
            return n;
        }
        finally {
            ++this.charReadCount;
        }
    }

    private void assertCurrentSegmentExists() {
        if (this.segmentBuffer.length() == 0) {
            throw new IllegalStateException("No current segment available.  Possible conditions: \n\t\t1. A call to moveToNextSegment() was not made, or \n\t\t2. The last call to moveToNextSegment() returned false.");
        }
    }
}

