/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.ext;

import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.w3c.dom.Element;

public class SelectorPropertyResolver
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
        SmooksResourceConfiguration populatorConfig = extensionContext.getResourceStack().peek();
        SelectorPropertyResolver.resolveSelectorTokens(populatorConfig);
    }

    public static void resolveSelectorTokens(SmooksResourceConfiguration populatorConfig) {
        QName valueAttributeQName = populatorConfig.getTargetAttributeQName();
        if (valueAttributeQName != null) {
            String valueAttributeName = valueAttributeQName.getLocalPart();
            String valueAttributePrefix = valueAttributeQName.getPrefix();
            populatorConfig.setParameter("valueAttributeName", valueAttributeName);
            if (valueAttributePrefix != null && !valueAttributePrefix.trim().equals("")) {
                populatorConfig.setParameter("valueAttributePrefix", valueAttributePrefix);
            }
        }
    }

    public static String getSelectorProperty(String[] selectorTokens) {
        StringBuffer selectorProp = new StringBuffer();
        for (String selectorToken : selectorTokens) {
            if (selectorToken.trim().startsWith("@")) continue;
            selectorProp.append(selectorToken).append(" ");
        }
        return selectorProp.toString().trim();
    }
}

