/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.admin.Application;
import org.switchyard.admin.Component;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.admin.base.BaseComponent;
import org.switchyard.admin.base.BaseComponentReference;
import org.switchyard.admin.base.BaseJavaComponentService;
import org.switchyard.admin.base.BaseNoopComponentService;
import org.switchyard.admin.base.BaseReference;
import org.switchyard.admin.base.BaseService;
import org.switchyard.admin.base.BaseTransformer;
import org.switchyard.admin.base.BaseValidator;
import org.switchyard.admin.base.BaseWsdlComponentService;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeReferenceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.property.PropertyModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.validate.ValidateModel;
import org.switchyard.deploy.ComponentNames;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.event.EventObserver;
import org.switchyard.runtime.event.ExchangeCompletionEvent;

public class BaseApplication
implements Application,
EventObserver {
    private final QName _name;
    private Map<QName, Service> _services;
    private Map<QName, Reference> _references;
    private Map<QName, Component> _components;
    private Map<QName, ComponentService> _componentServices;
    private List<Transformer> _transformers;
    private List<Validator> _validators;
    private AbstractDeployment _deployment;
    private Map<String, String> _properties;

    public BaseApplication(AbstractDeployment deployment) {
        this._name = deployment.getName();
        this._deployment = deployment;
        this.addTransformers();
        this.addValidators();
        this.addComponents();
        this.addServices();
        this.addReferences();
        this.addProperties();
        this._deployment.getDomain().addEventObserver((EventObserver)this, ExchangeCompletionEvent.class);
    }

    void dispose() {
        this._deployment.getDomain().removeObserver((EventObserver)this);
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public List<Service> getServices() {
        if (this._services == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Service>(this._services.values());
    }

    @Override
    public List<Reference> getReferences() {
        if (this._references == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Reference>(this._references.values());
    }

    @Override
    public Service getService(QName serviceName) {
        if (this._services == null) {
            return null;
        }
        return this._services.get(serviceName);
    }

    @Override
    public Reference getReference(QName referenceName) {
        if (this._references == null) {
            return null;
        }
        return this._references.get(referenceName);
    }

    @Override
    public SwitchYardModel getConfig() {
        return this._deployment.getConfig();
    }

    @Override
    public List<ComponentService> getComponentServices() {
        if (this._componentServices == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ComponentService>(this._componentServices.values());
    }

    @Override
    public ComponentService getComponentService(QName componentServiceName) {
        if (this._componentServices == null) {
            return null;
        }
        return this._componentServices.get(componentServiceName);
    }

    @Override
    public Component getComponent(QName name) {
        return this._components.get(name);
    }

    @Override
    public List<Component> getComponents() {
        return new ArrayList<Component>(this._components.values());
    }

    @Override
    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this._transformers);
    }

    @Override
    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this._validators);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public void notify(EventObject event) {
        if (event instanceof ExchangeCompletionEvent) {
            this.exchangeCompleted((ExchangeCompletionEvent)event);
        }
    }

    public AbstractDeployment getDeployment() {
        return this._deployment;
    }

    private void addServices() {
        this._services = new LinkedHashMap<QName, Service>();
        if (this.getConfig().getComposite().getServices() == null) {
            return;
        }
        for (CompositeServiceModel service : this.getConfig().getComposite().getServices()) {
            this._services.put(service.getQName(), new BaseService(service, this));
        }
    }

    private void addReferences() {
        this._references = new LinkedHashMap<QName, Reference>();
        if (this.getConfig().getComposite().getReferences() == null) {
            return;
        }
        for (CompositeReferenceModel ref : this.getConfig().getComposite().getReferences()) {
            this._references.put(ref.getQName(), new BaseReference(ref, this));
        }
    }

    private void addTransformers() {
        this._transformers = new LinkedList<Transformer>();
        if (this.getConfig().getTransforms() == null) {
            return;
        }
        for (TransformModel transformModel : this.getConfig().getTransforms().getTransforms()) {
            this._transformers.add(new BaseTransformer(transformModel));
        }
    }

    private void addValidators() {
        this._validators = new LinkedList<Validator>();
        if (this.getConfig().getValidates() == null) {
            return;
        }
        for (ValidateModel validateModel : this.getConfig().getValidates().getValidates()) {
            this._validators.add(new BaseValidator(validateModel));
        }
    }

    private void addComponents() {
        this._components = new LinkedHashMap<QName, Component>();
        this._componentServices = new LinkedHashMap<QName, ComponentService>();
        if (this.getConfig().getComposite().getComponents() == null) {
            return;
        }
        for (ComponentModel componentConfig : this.getConfig().getComposite().getComponents()) {
            ComponentService service;
            if (componentConfig.getServices().size() > 0) {
                ComponentServiceModel serviceConfig = (ComponentServiceModel)componentConfig.getServices().get(0);
                service = serviceConfig.getInterface() == null ? new BaseNoopComponentService(serviceConfig, componentConfig, this) : ("java".equals(serviceConfig.getInterface().getType()) ? new BaseJavaComponentService(serviceConfig, componentConfig, this) : ("wsdl".equals(serviceConfig.getInterface().getType()) ? new BaseWsdlComponentService(serviceConfig, componentConfig, this) : new BaseNoopComponentService(serviceConfig, componentConfig, this)));
                this._componentServices.put(serviceConfig.getQName(), service);
            } else {
                service = null;
            }
            LinkedHashMap<QName, ComponentReference> references = new LinkedHashMap<QName, ComponentReference>();
            if (service == null) {
                for (ComponentReferenceModel referenceModel : componentConfig.getReferences()) {
                    references.put(referenceModel.getQName(), new BaseComponentReference(referenceModel.getQName(), this.getInterfaceName(referenceModel.getInterface())));
                }
            } else {
                for (ComponentReference reference : service.getReferences()) {
                    references.put(reference.getName(), reference);
                }
            }
            BaseComponent component = new BaseComponent(componentConfig.getQName(), componentConfig.getImplementation() == null ? "null" : componentConfig.getImplementation().getType(), service, references, this.convertProperties(componentConfig.getProperties()));
            this._components.put(component.getName(), component);
        }
    }

    private void addProperties() {
        this._properties = this.getConfig().getComposite() == null ? this.convertProperties(null) : this.convertProperties(this.getConfig().getComposite().getProperties());
    }

    private Map<String, String> convertProperties(Map<String, PropertyModel> properties) {
        LinkedHashMap<String, String> retVal = new LinkedHashMap<String, String>();
        if (properties == null) {
            return retVal;
        }
        for (PropertyModel property : properties.values()) {
            retVal.put(property.getName(), property.getValue());
        }
        return retVal;
    }

    private String getInterfaceName(InterfaceModel interfaceModel) {
        if (interfaceModel == null) {
            return null;
        }
        return interfaceModel.getInterface();
    }

    void exchangeCompleted(ExchangeCompletionEvent event) {
        Exchange exchange = event.getExchange();
        QName qualifiedReferenceName = exchange.getConsumer().getName();
        QName referenceName = ComponentNames.unqualify((QName)qualifiedReferenceName);
        QName componentName = ComponentNames.componentName((QName)qualifiedReferenceName);
        if (componentName == null) {
            Service service = this._services.get(referenceName);
            if (service != null) {
                service.recordMetrics(exchange);
            }
        } else {
            ComponentReference reference;
            QName serviceName = exchange.getProvider().getName();
            ComponentService service = this._componentServices.get(serviceName);
            if (service == null) {
                Reference reference2 = this._references.get(serviceName);
                if (reference2 != null) {
                    reference2.recordMetrics(exchange);
                }
            } else {
                service.recordMetrics(exchange);
            }
            Component component = this._components.get(componentName);
            if (component != null && (reference = component.getReference(referenceName)) != null) {
                reference.recordMetrics(exchange);
            }
        }
    }
}

