/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.switchyard.common.type.Classes;

public final class ProviderRegistry {
    private static Registry _registry;
    private static Logger _logger;

    private ProviderRegistry() {
    }

    public static <T> T getProvider(Class<T> clazz) {
        return ProviderRegistry.getProvider(clazz, Classes.getTCCL());
    }

    public static <T> T getProvider(Class<T> clazz, ClassLoader loader) {
        if (_registry != null) {
            return _registry.getProvider(clazz);
        }
        ServiceLoader<T> services = ServiceLoader.load(clazz, loader);
        Iterator<T> iterator = services.iterator();
        while (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (Throwable t) {
                _logger.debug((Object)("Error creating provider for class " + clazz.getName()), t);
            }
        }
        return null;
    }

    public static <T> List<T> getProviders(Class<T> clazz) {
        return ProviderRegistry.getProviders(clazz, Classes.getTCCL());
    }

    public static <T> List<T> getProviders(Class<T> clazz, ClassLoader loader) {
        if (_registry != null) {
            return _registry.getProviders(clazz);
        }
        ArrayList<T> list = new ArrayList<T>();
        ServiceLoader<T> services = ServiceLoader.load(clazz, loader);
        Iterator<T> iterator = services.iterator();
        while (iterator.hasNext()) {
            try {
                list.add(iterator.next());
            }
            catch (Throwable t) {
                _logger.debug((Object)("Error creating provider for class " + clazz.getName()), t);
            }
        }
        return list;
    }

    public static void setRegistry(Registry registry) {
        _registry = registry;
    }

    static {
        _logger = Logger.getLogger(ProviderRegistry.class);
    }

    public static interface Registry {
        public <T> T getProvider(Class<T> var1);

        public <T> List<T> getProviders(Class<T> var1);
    }
}

