/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.validate.config.model.v1;

import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseMarshaller;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.validate.config.model.v1.V1FileEntryModel;
import org.switchyard.validate.config.model.v1.V1JavaValidateModel;
import org.switchyard.validate.config.model.v1.V1SchemaCatalogsModel;
import org.switchyard.validate.config.model.v1.V1SchemaFilesModel;
import org.switchyard.validate.config.model.v1.V1XmlValidateModel;

public class V1ValidateMarshaller
extends BaseMarshaller {
    private static final String VALIDATE_JAVA = "validate.java";
    private static final String VALIDATE_XML = "validate.xml";

    public V1ValidateMarshaller(Descriptor desc) {
        super(desc);
    }

    public Model read(Configuration config) {
        String name = config.getName();
        Descriptor desc = this.getDescriptor();
        if (name.equals(VALIDATE_JAVA)) {
            return new V1JavaValidateModel(config, desc);
        }
        if (name.equals(VALIDATE_XML)) {
            return new V1XmlValidateModel(config, desc);
        }
        if (name.equals("schemaFiles")) {
            return new V1SchemaFilesModel(config, desc);
        }
        if (name.equals("schemaCatalogs")) {
            return new V1SchemaCatalogsModel(config, desc);
        }
        if (name.equals("entry")) {
            return new V1FileEntryModel(config, desc);
        }
        return null;
    }
}

