/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.extensions.wsdl;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.extensions.wsdl.WSDLExtensionsMessages;
import org.switchyard.extensions.wsdl.WSDLReader;
import org.switchyard.extensions.wsdl.WSDLReaderException;
import org.switchyard.metadata.BaseService;
import org.switchyard.metadata.ServiceOperation;
import org.w3c.dom.Element;

public final class WSDLService
extends BaseService {
    public static final String TYPE = "wsdl";
    private static final String PORTTYPE = "wsdl.porttype";
    private String _wsdlLocation;
    private QName _portType;

    private WSDLService(QName portType, Set<ServiceOperation> operations, String wsdlLocation) {
        super(operations, TYPE);
        this._portType = portType;
        this._wsdlLocation = wsdlLocation;
    }

    public static WSDLService fromWSDL(String wsdlLocationURI) throws WSDLReaderException {
        int index = wsdlLocationURI.indexOf("#");
        if (index > 0) {
            String wsdlLocation = wsdlLocationURI.substring(0, index);
            String localPart = wsdlLocationURI.substring(index + 1);
            String portName = null;
            if (!localPart.contains(PORTTYPE)) {
                throw WSDLExtensionsMessages.MESSAGES.invalidWSDLInterfacePart(wsdlLocationURI);
            }
            portName = localPart.substring(PORTTYPE.length() + 1, localPart.length() - 1);
            return WSDLService.fromWSDL(wsdlLocation, portName);
        }
        throw WSDLExtensionsMessages.MESSAGES.invalidWSDLInterface(wsdlLocationURI);
    }

    public static WSDLService fromWSDL(String wsdlLocation, String portName) throws WSDLReaderException {
        WSDLReader reader = new WSDLReader();
        HashSet<ServiceOperation> ops = reader.readWSDL(wsdlLocation, portName);
        Element wsdl = reader.readWSDL(wsdlLocation);
        QName portType = new QName(wsdl.getAttribute("targetNamespace"), portName);
        return new WSDLService(portType, ops, wsdlLocation);
    }

    public String getWSDLLocation() {
        return this._wsdlLocation;
    }

    public QName getPortType() {
        return this._portType;
    }
}

