/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.replayer;

import java.util.Date;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.replayer.Replayer;
import org.apache.ode.bpel.engine.replayer.ReplayerBpelRuntimeContextImpl;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Scheduler;

public class ReplayerScheduler
implements Scheduler {
    private static final Log __log = LogFactory.getLog(ReplayerScheduler.class);
    public Replayer replayer;
    public static ThreadLocal<TaskElement> currentTaskElement = new ThreadLocal();
    private PriorityQueue<TaskElement> taskQueue = new PriorityQueue();

    public void scheduleReplayerJob(Callable action, Date when, ReplayerBpelRuntimeContextImpl runtimeContext) {
        this.taskQueue.add(new TaskElement(when, action, runtimeContext));
    }

    public void cancelJob(String jobId) throws ContextException {
        throw new IllegalStateException();
    }

    public <T> T execTransaction(Callable<T> transaction) throws Exception, ContextException {
        throw new IllegalStateException();
    }

    public <T> T execTransaction(Callable<T> transaction, int timeout) throws Exception, ContextException {
        throw new IllegalStateException();
    }

    public boolean isTransacted() {
        return true;
    }

    public void registerSynchronizer(Scheduler.Synchronizer synch) throws ContextException {
        throw new IllegalStateException();
    }

    public void setJobProcessor(Scheduler.JobProcessor processor) throws ContextException {
        throw new IllegalStateException();
    }

    public void setRollbackOnly() throws Exception {
        throw new IllegalStateException();
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReplaying(Replayer replayer) throws Exception {
        this.replayer = replayer;
        while (!this.taskQueue.isEmpty()) {
            TaskElement taskElement = (TaskElement)this.taskQueue.remove();
            try {
                currentTaskElement.set(taskElement);
                __log.debug((Object)("executing action at time " + taskElement.when));
                if (taskElement.runtimeContext != null) {
                    taskElement.runtimeContext.setCurrentEventDateTime(taskElement.when);
                }
                taskElement.action.call();
            }
            finally {
                currentTaskElement.set(null);
            }
        }
    }

    public void stop() {
    }

    public void start() {
    }

    public <T> Future<T> execIsolatedTransaction(Callable<T> transaction) throws Exception, ContextException {
        return null;
    }

    public String scheduleMapSerializableRunnable(Scheduler.MapSerializableRunnable runnable, Date when) throws ContextException {
        return null;
    }

    public String schedulePersistedJob(final Scheduler.JobDetails jobDetail, Date when1) throws ContextException {
        final Date when = when1 == null ? ReplayerScheduler.currentTaskElement.get().when : when1;
        __log.debug((Object)("schedulePersistedJob " + jobDetail + " " + when), (Throwable)new Exception());
        this.scheduleReplayerJob(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ReplayerScheduler.this.replayer.handleJobDetails(jobDetail, when);
                return null;
            }
        }, when, null);
        return null;
    }

    public void setPolledRunnableProcesser(Scheduler.JobProcessor polledRunnableProcessor) {
    }

    public String scheduleVolatileJob(boolean transacted, Scheduler.JobDetails jobDetail, Date when) throws ContextException {
        __log.debug((Object)"scheduleVolatileJob");
        return null;
    }

    public String scheduleVolatileJob(boolean transacted, Scheduler.JobDetails jobDetail) throws ContextException {
        __log.debug((Object)"scheduleVolatileJob");
        return null;
    }

    private static class TaskElement
    implements Comparable<TaskElement> {
        public final Date when;
        public final Callable<Object> action;
        public final ReplayerBpelRuntimeContextImpl runtimeContext;

        public TaskElement(Date when, Callable<Object> action, ReplayerBpelRuntimeContextImpl runtimeContext) {
            this.when = when;
            this.action = action;
            this.runtimeContext = runtimeContext;
        }

        @Override
        public int compareTo(TaskElement o) {
            return this.when.compareTo(o.when);
        }
    }
}

