/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.io.pull;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import org.switchyard.common.CommonCoreMessages;
import org.switchyard.common.io.pull.Puller;

public class PropertiesPuller
extends Puller<Properties> {
    private final PropertiesType _type;

    public PropertiesPuller() {
        this(PropertiesType.PROPERTIES);
    }

    public PropertiesPuller(PropertiesType type) {
        this._type = type;
    }

    @Override
    public Properties pull(InputStream stream) throws IOException {
        Properties props = new Properties();
        if (stream != null) {
            switch (this._type) {
                case PROPERTIES: {
                    props.load(stream);
                    break;
                }
                case XML: {
                    props.loadFromXML(stream);
                    break;
                }
                default: {
                    throw CommonCoreMessages.MESSAGES.unsupportedPropertiesTypeForMethod(this._type, "pull(InputStream)");
                }
            }
        }
        return props;
    }

    public Properties pull(Reader reader) throws IOException {
        Properties props = new Properties();
        if (reader != null) {
            switch (this._type) {
                case PROPERTIES: {
                    props.load(reader);
                    break;
                }
                default: {
                    throw CommonCoreMessages.MESSAGES.unsupportedPropertiesTypeForMethod(this._type, "pull(Reader)");
                }
            }
        }
        return props;
    }

    public Properties pull(Map<String, String> map) {
        Properties props = new Properties();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                props.setProperty(key, value);
            }
        }
        return props;
    }

    public static enum PropertiesType {
        PROPERTIES,
        XML;

    }
}

