/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;
import org.apache.ode.utils.cli.LastArgument;

public class Fragments {
    private CommandlineFragment[] _cl;
    private CommandlineSyntaxException _reason;

    public Fragments(CommandlineFragment[] frags) {
        this._cl = frags;
    }

    public void resetFragments() {
        for (int i = 0; i < this._cl.length; ++i) {
            this._cl[i].reset();
        }
    }

    public CommandlineFragment[] getFragments() {
        return this._cl;
    }

    public CommandlineFragment[] getFragmentsInUserOrder() {
        if (this._cl == null || this._cl.length == 0) {
            return this._cl;
        }
        CommandlineFragment[] cf = new CommandlineFragment[this._cl.length];
        int lasts = 0;
        for (int i = 0; i < this._cl.length; ++i) {
            if (this._cl[i] instanceof LastArgument) {
                cf[this._cl.length - ++lasts] = this._cl[i];
                continue;
            }
            cf[i - lasts] = this._cl[i];
        }
        return cf;
    }

    public CommandlineSyntaxException getReason() {
        return this._reason;
    }

    public boolean matches(String[] s) {
        this.resetFragments();
        try {
            int i;
            List<String> l = new ArrayList<String>();
            for (i = 0; i < s.length; ++i) {
                l.add(s[i]);
            }
            for (i = 0; i < this._cl.length; ++i) {
                l = this._cl[i].consume(l);
            }
            if (l.size() != 0) {
                StringBuffer sb = new StringBuffer();
                Iterator<String> it = l.iterator();
                while (it.hasNext()) {
                    if (sb.length() != 0) {
                        sb.append(' ');
                    }
                    sb.append(it.next());
                }
                this._reason = new CommandlineSyntaxException("Not sure what to do with the extra items: " + sb.toString());
                return false;
            }
            return true;
        }
        catch (CommandlineSyntaxException cse) {
            this._reason = cse;
            this.resetFragments();
            return false;
        }
    }
}

