/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.xslt.internal;

import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.jboss.logging.Logger;
import org.switchyard.Message;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.internal.TransformLogger;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.xslt.internal.TransformerPool;
import org.w3c.dom.Document;

@Scannable(value=false)
public class XsltTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private static final Logger LOGGER = Logger.getLogger(XsltTransformer.class);
    private Templates _templates;
    private TransformerPool _transformerPool;
    private boolean _failOnWarning;

    public XsltTransformer(QName from, QName to, Templates templates, boolean failOnWarning, int maxPoolSize) {
        super(from, to);
        this._templates = templates;
        this._failOnWarning = failOnWarning;
        if (maxPoolSize > 0) {
            this._transformerPool = new TransformerPool(templates, maxPoolSize, new XsltTransformerErrorListener(this._failOnWarning));
        }
    }

    public Message transform(Message message) {
        block7: {
            Transformer transformer = null;
            try {
                DOMSource source = (DOMSource)message.getContent(DOMSource.class);
                DOMResult result = new DOMResult();
                if (this._transformerPool != null) {
                    transformer = this._transformerPool.take();
                } else {
                    transformer = this._templates.newTransformer();
                    transformer.setErrorListener(new XsltTransformerErrorListener(this._failOnWarning));
                }
                transformer.transform(source, result);
                message.setContent((Object)((Document)result.getNode()).getDocumentElement());
                if (this._transformerPool == null || transformer == null) break block7;
                this._transformerPool.give(transformer);
            }
            catch (Exception e) {
                try {
                    throw TransformMessages.MESSAGES.errorDuringXsltTransformation(e);
                }
                catch (Throwable throwable) {
                    if (this._transformerPool != null && transformer != null) {
                        this._transformerPool.give(transformer);
                    }
                    throw throwable;
                }
            }
        }
        return message;
    }

    TransformerPool getTransformerPool() {
        return this._transformerPool;
    }

    private class XsltTransformerErrorListener
    implements ErrorListener {
        private boolean _failOnWarning;

        public XsltTransformerErrorListener(boolean failOnWarning) {
            this._failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException ex) throws TransformerException {
            if (this._failOnWarning) {
                throw ex;
            }
            TransformLogger.ROOT_LOGGER.warningDuringTransformation(ex);
        }

        @Override
        public void error(TransformerException ex) throws TransformerException {
            throw ex;
        }

        @Override
        public void fatalError(TransformerException ex) throws TransformerException {
            throw ex;
        }
    }
}

