/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.services;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.network.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.switchyard.common.net.SocketAddr;

public class SwitchYardInjectorService
implements Service<Map<String, String>> {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"SwitchYardInjectorService"});
    private final Map<String, String> _injectedValues = new HashMap<String, String>();
    private final Map<String, InjectedValue<SocketBinding>> _socketBindings = new HashMap<String, InjectedValue<SocketBinding>>();

    public Map<String, String> getValue() throws IllegalStateException, IllegalArgumentException {
        return this._injectedValues;
    }

    public void start(StartContext context) throws StartException {
        for (String key : this._socketBindings.keySet()) {
            SocketBinding binding = (SocketBinding)this._socketBindings.get(key).getValue();
            SocketAddr addr = new SocketAddr(binding.getAddress().getHostAddress(), binding.getPort());
            LOG.trace((Object)("Injecting socket binding '" + addr + "'"));
            this._injectedValues.put(key, addr.toString());
        }
    }

    public void stop(StopContext context) {
    }

    public InjectedValue<SocketBinding> getSocketBinding(String name) {
        InjectedValue binding = this._socketBindings.get(name);
        if (binding == null) {
            binding = new InjectedValue();
            this._socketBindings.put(name, (InjectedValue<SocketBinding>)binding);
        }
        return binding;
    }
}

