/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.xml;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.common.CommonCoreMessages;
import org.switchyard.common.type.Classes;

public final class QNameUtil {
    public static final String JAVA_TYPE = "java";
    private static final String JAVA_TYPE_PREFIX = "java:";
    private static final List<String> PRIMITIVES = Arrays.asList("byte[]", "short[]", "int[]", "long[]", "float[]", "double[]", "boolean[]", "char[]");

    private QNameUtil() {
    }

    public static boolean isJavaMessageType(QName name) {
        return name.getLocalPart().startsWith(JAVA_TYPE_PREFIX);
    }

    public static Class<?> toJavaMessageType(QName name) {
        if (!QNameUtil.isJavaMessageType(name)) {
            throw CommonCoreMessages.MESSAGES.invalidCall();
        }
        String className = name.getLocalPart().substring(JAVA_TYPE_PREFIX.length());
        if (!PRIMITIVES.contains(className) && className.contains("[]")) {
            className = className.substring(0, className.length() - 2);
            return Array.newInstance(Classes.forName(className), 0).getClass();
        }
        return Classes.forName(className);
    }
}

