/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il.dbutil;

import java.io.File;
import java.sql.Connection;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.DatabaseConfigException;
import org.apache.ode.il.dbutil.DatabaseConnectionManager;
import org.apache.ode.il.dbutil.EmbeddedDatabase;
import org.apache.ode.utils.GUID;
import org.h2.Driver;
import org.h2.jdbcx.JdbcDataSource;

public class H2Database
implements EmbeddedDatabase {
    private static final Log __log = LogFactory.getLog(H2Database.class);
    private DatabaseConnectionManager _connectionManager;
    private String _dbUrl = null;
    private DataSource _dataSource = null;

    @Override
    public void init(File workRoot, OdeConfigProperties props, TransactionManager txm) {
        String db = props.getDbEmbeddedName();
        String rollbackedDS = props.getProperties().getProperty("needed.Rollback");
        if ("true".equals(rollbackedDS) || workRoot != null) {
            db = db + new GUID().toString();
        }
        if (workRoot == null) {
            this._dbUrl = "jdbc:h2:mem:" + db + ";DB_CLOSE_DELAY=-1";
        } else {
            this._dbUrl = "jdbc:h2:" + workRoot + File.separator + db;
            if (!props.isDbEmbeddedCreate()) {
                this._dbUrl = this._dbUrl + ";IFEXISTS=TRUE";
            }
        }
        __log.info((Object)("The db url is: " + this._dbUrl));
        __log.info((Object)("The rollbackedDS: " + rollbackedDS + ":workRoot ->" + workRoot));
        if (workRoot != null || "true".equals(rollbackedDS)) {
            String clazz = Driver.class.getName();
            this._connectionManager = new DatabaseConnectionManager(txm, props);
            try {
                this._connectionManager.init(this._dbUrl, clazz, "sa", null);
            }
            catch (DatabaseConfigException ex) {
                __log.error((Object)"Unable to initialize connection pool", (Throwable)ex);
            }
            this._dataSource = this._connectionManager.getDataSource();
        } else {
            JdbcDataSource hds = new JdbcDataSource();
            hds.setURL(this._dbUrl);
            hds.setUser("sa");
            this._dataSource = hds;
        }
        __log.info((Object)("Using Embedded Database: " + this._dbUrl));
    }

    @Override
    public void shutdown() {
        if (this._connectionManager != null) {
            try {
                this._connectionManager.shutdown();
            }
            catch (DatabaseConfigException ex) {
                __log.error((Object)"unable to shutdown connection pool", (Throwable)ex);
            }
        }
        try {
            Connection conn = this.getDataSource().getConnection();
            conn.createStatement().execute("SHUTDOWN");
        }
        catch (Throwable ex) {
            __log.debug((Object)"Error shutting down H2.", ex);
        }
    }

    @Override
    public DataSource getDataSource() {
        return this._dataSource;
    }
}

