/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.sap.model.v2;

import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.sap.model.IDocServerModel;
import org.switchyard.component.camel.sap.model.v2.V2ServerModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V2IDocServerModel
extends V2ServerModel
implements IDocServerModel {
    public V2IDocServerModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    public V2IDocServerModel(String namespace, String name) {
        super(namespace, name);
        this.setModelChildrenOrder(new String[]{"serverName", "idocType", "idocTypeExtension", "systemRelease", "applicationRelease"});
    }

    @Override
    public String getIdocType() {
        return this.getConfig("idocType");
    }

    @Override
    public IDocServerModel setIdocType(String idoc) {
        this.setConfig("idocType", idoc);
        return this;
    }

    @Override
    public String getIdocTypeExtension() {
        return this.getConfig("idocTypeExtension");
    }

    @Override
    public IDocServerModel setIdocTypeExtension(String idocExt) {
        this.setConfig("idocTypeExtension", idocExt);
        return this;
    }

    @Override
    public String getSystemRelease() {
        return this.getConfig("systemRelease");
    }

    @Override
    public IDocServerModel setSystemRelease(String sysRelease) {
        this.setConfig("systemRelease", sysRelease);
        return null;
    }

    @Override
    public String getApplicationRelease() {
        return this.getConfig("applicationRelease");
    }

    @Override
    public IDocServerModel setApplicationRelease(String appRelease) {
        this.setConfig("applicationRelease", appRelease);
        return this;
    }

    @Override
    public StringBuilder createBaseURIString(QueryString queryString) {
        StringBuilder buf = new StringBuilder(this.getSchema()).append(':').append(this.getServerName()).append(':').append(this.getIdocType());
        String idocTypeExt = this.getIdocTypeExtension();
        if (idocTypeExt != null && !idocTypeExt.isEmpty()) {
            buf.append(':').append(idocTypeExt);
            String sysRel = this.getSystemRelease();
            if (sysRel != null && !sysRel.isEmpty()) {
                buf.append(':').append(sysRel);
                String appRel = this.getApplicationRelease();
                if (appRel != null && !appRel.isEmpty()) {
                    buf.append(':').append(appRel);
                }
            }
        }
        return buf;
    }
}

