/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.examples.eratosthenes;

import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.SynchChannel;
import org.apache.ode.jacob.SynchChannelListener;
import org.apache.ode.jacob.examples.eratosthenes.NaturalNumberStreamChannel;
import org.apache.ode.jacob.examples.eratosthenes.NaturalNumberStreamChannelListener;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.jacob.vpu.JacobVPU;

public class Sieve
extends JacobRunnable {
    private static final long serialVersionUID = -1303509567096202776L;
    private static int _cnt = 0;
    private static int _last = 0;

    @Override
    public void run() {
        NaturalNumberStreamChannel integers = this.newChannel(NaturalNumberStreamChannel.class);
        NaturalNumberStreamChannel primes = this.newChannel(NaturalNumberStreamChannel.class);
        Sieve.instance(new Counter(integers, 2));
        Sieve.instance(new Head(integers, primes));
        Sieve.instance(new Print(primes));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("JACOB Sieve of Eratosthenes Prime Number Generator Demonstration");
            System.err.println("usage: java " + Sieve.class.getName() + " requested-prime");
            System.err.println("  requested-prime = which prime to show (0->inf)");
            System.exit(1);
        } else {
            int request = Integer.parseInt(args[0]);
            JacobVPU vpu = new JacobVPU();
            vpu.setContext(new ExecutionQueueImpl(null));
            vpu.inject(new Sieve());
            while (_cnt != request) {
                vpu.execute();
            }
            System.err.println("The " + _cnt + "th prime is " + _last);
        }
    }

    private static class PrimeFilter
    extends JacobRunnable {
        private static final long serialVersionUID = 1569523200422202448L;
        private int _prime;
        private NaturalNumberStreamChannel _in;
        private NaturalNumberStreamChannel _out;

        public PrimeFilter(int prime, NaturalNumberStreamChannel in, NaturalNumberStreamChannel out) {
            this._prime = prime;
            this._in = in;
            this._out = out;
        }

        @Override
        public void run() {
            PrimeFilter.object(true, new NaturalNumberStreamChannelListener(this._in){
                private static final long serialVersionUID = 6625386475773075604L;

                @Override
                public void val(int n, final SynchChannel ret) {
                    if (n % PrimeFilter.this._prime != 0) {
                        PrimeFilter.this._out.val(n, 1.object(new SynchChannelListener(this.newChannel(SynchChannel.class)){
                            private static final long serialVersionUID = 2523405590764193613L;

                            @Override
                            public void ret() {
                                ret.ret();
                            }
                        }));
                    } else {
                        ret.ret();
                    }
                }
            });
        }
    }

    private static final class Print
    extends JacobRunnable {
        private static final long serialVersionUID = -3134193737519487672L;
        private NaturalNumberStreamChannel _in;

        public Print(NaturalNumberStreamChannel in) {
            this._in = in;
        }

        @Override
        public void run() {
            Print.object(true, new NaturalNumberStreamChannelListener(this._in){
                private static final long serialVersionUID = 7671019806323866866L;

                @Override
                public void val(int n, SynchChannel ret) {
                    _cnt++;
                    _last = n;
                    System.out.println("PRIME: " + n);
                    ret.ret();
                }
            });
        }
    }

    private static final class Head
    extends JacobRunnable {
        private static final long serialVersionUID = 1791641314141082728L;
        NaturalNumberStreamChannel _in;
        NaturalNumberStreamChannel _primes;

        public Head(NaturalNumberStreamChannel in, NaturalNumberStreamChannel primes) {
            this._in = in;
            this._primes = primes;
        }

        @Override
        public void run() {
            Head.object(new NaturalNumberStreamChannelListener(this._in){
                private static final long serialVersionUID = -2145752474431263689L;

                @Override
                public void val(final int n, final SynchChannel ret) {
                    Head.this._primes.val(n, 1.object(new SynchChannelListener(this.newChannel(SynchChannel.class)){
                        private static final long serialVersionUID = -3009595654233593893L;

                        @Override
                        public void ret() {
                            NaturalNumberStreamChannel x = this.newChannel(NaturalNumberStreamChannel.class);
                            Head.1.instance(new PrimeFilter(n, Head.this._in, x));
                            Head.1.instance(new Head(x, Head.this._primes));
                            ret.ret();
                        }
                    }));
                }
            });
        }
    }

    private static class Counter
    extends JacobRunnable {
        private static final long serialVersionUID = 4739323750438991003L;
        private NaturalNumberStreamChannel _out;
        private int _n;

        public Counter(NaturalNumberStreamChannel out, int n) {
            this._out = out;
            this._n = n;
        }

        @Override
        public void run() {
            this._out.val(this._n, Counter.object(new SynchChannelListener(this.newChannel(SynchChannel.class)){
                private static final long serialVersionUID = -4336285925619915276L;

                @Override
                public void ret() {
                    1.instance(new Counter(Counter.this._out, Counter.this._n + 1));
                }
            }));
        }
    }

    public class Foo {
    }
}

