/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential;

import java.security.Principal;
import org.switchyard.security.credential.Credential;

public class PrincipalCredential
implements Credential {
    private static final long serialVersionUID = 904862054504518758L;
    private static final String FORMAT = PrincipalCredential.class.getSimpleName() + "@%s[principal=%s, trusted=%s]";
    private final Principal _principal;
    private final boolean _trusted;

    public PrincipalCredential(Principal principal) {
        this(principal, false);
    }

    public PrincipalCredential(Principal principal, boolean trusted) {
        this._principal = principal;
        this._trusted = trusted;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public boolean isTrusted() {
        return this._trusted;
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._principal, this._trusted);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._principal == null ? 0 : this._principal.hashCode());
        result = 31 * result + (this._trusted ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrincipalCredential other = (PrincipalCredential)obj;
        if (this._principal == null ? other._principal != null : !this._principal.equals(other._principal)) {
            return false;
        }
        return this._trusted == other._trusted;
    }
}

