/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.credential.extractor;

import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.switchyard.security.BaseSecurityMessages;
import org.switchyard.security.credential.CertificateCredential;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.Credential;
import org.switchyard.security.credential.PrincipalCredential;
import org.switchyard.security.credential.extractor.CredentialExtractor;

public class SSLSessionCredentialExtractor
implements CredentialExtractor<SSLSession> {
    @Override
    public Set<Credential> extract(SSLSession source) {
        HashSet<Credential> credentials = new HashSet<Credential>();
        try {
            credentials.add(new ConfidentialityCredential(source.isValid()));
            credentials.add(new PrincipalCredential(source.getPeerPrincipal()));
            credentials.add(new CertificateCredential(source.getPeerCertificates()[0]));
        }
        catch (SSLPeerUnverifiedException e) {
            throw BaseSecurityMessages.MESSAGES.unableToExtractCredentials(e.getMessage(), e);
        }
        return credentials;
    }
}

