/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.switchyard.admin.Application;
import org.switchyard.admin.SwitchYard;
import org.switchyard.as7.extension.services.SwitchYardAdminService;
import org.switchyard.config.model.switchyard.ArtifactModel;

public final class SwitchYardSubsystemUsesArtifact
implements OperationStepHandler {
    public static final SwitchYardSubsystemUsesArtifact INSTANCE = new SwitchYardSubsystemUsesArtifact();

    private SwitchYardSubsystemUsesArtifact() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ModelNode applications = context.getResult();
                ServiceController controller = context.getServiceRegistry(false).getRequiredService(SwitchYardAdminService.SERVICE_NAME);
                String name = operation.hasDefined("name") ? operation.get("name").asString() : null;
                String url = operation.hasDefined("url") ? operation.get("url").asString() : null;
                SwitchYard switchYard = (SwitchYard)SwitchYard.class.cast(controller.getService().getValue());
                for (Application application : switchYard.getApplications()) {
                    if (application.getConfig().getArtifacts() == null) continue;
                    for (ArtifactModel artiact : application.getConfig().getArtifacts().getArtifacts()) {
                        if (name != null && !name.equals(artiact.getName()) || url != null && !url.equals(artiact.getURL())) continue;
                        applications.add(application.getName().toString());
                    }
                }
                context.stepCompleted();
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

