/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.file;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.container.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListAccessor {
    private static final String ALL_LIST_FILE_NAME_CONTEXT_KEY = FileListAccessor.class.getName() + "#allListFileName";

    private FileListAccessor() {
    }

    public static void addFileName(String fileName, ExecutionContext execContext) {
        AssertArgument.isNotNullAndNotEmpty(fileName, "fileName");
        ArrayList<String> allListFiles = (ArrayList<String>)execContext.getAttribute(ALL_LIST_FILE_NAME_CONTEXT_KEY);
        if (allListFiles == null) {
            allListFiles = new ArrayList<String>();
        }
        if (!allListFiles.contains(fileName)) {
            allListFiles.add(fileName);
        }
        execContext.setAttribute(ALL_LIST_FILE_NAME_CONTEXT_KEY, allListFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFileList(ExecutionContext executionContext, String fromFile) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fromFile));
            ArrayList<String> files = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                files.add(line);
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static List<String> getListFileNames(ExecutionContext executionContext) {
        return (List)executionContext.getAttribute(ALL_LIST_FILE_NAME_CONTEXT_KEY);
    }

    public static List<String> getListFileNames(Map attributes) {
        return (List)attributes.get(ALL_LIST_FILE_NAME_CONTEXT_KEY);
    }
}

