/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.component.common.CommonCommonLogger;
import org.switchyard.component.common.CommonCommonMessages;
import org.switchyard.component.common.DeliveryException;

public class SynchronousInOutHandler
implements ExchangeHandler {
    public static final long DEFAULT_TIMEOUT = 300000L;
    private static final Logger LOGGER = Logger.getLogger(SynchronousInOutHandler.class);
    private BlockingQueue<Exchange> _responseQueue = new ArrayBlockingQueue<Exchange>(1);

    public Exchange waitForOut() throws DeliveryException {
        return this.waitForOut(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange waitForOut(long timeout) throws DeliveryException {
        try {
            Object object;
            Exchange outExchange;
            try {
                outExchange = this._responseQueue.poll(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                SynchronousInOutHandler synchronousInOutHandler = this;
                synchronized (synchronousInOutHandler) {
                    this._responseQueue = null;
                    throw CommonCommonMessages.MESSAGES.unexpectedInterruptWhileWaitingOnOUTExchangeMessage(e);
                }
            }
            if (outExchange == null) {
                object = this;
                synchronized (object) {
                    if (this._responseQueue.isEmpty()) {
                        this._responseQueue = null;
                        throw CommonCommonMessages.MESSAGES.timedOutWaitingOnOUTExchangeMessage();
                    }
                    outExchange = (Exchange)this._responseQueue.poll();
                }
            }
            object = outExchange;
            return object;
        }
        finally {
            this._responseQueue = null;
        }
    }

    public synchronized void handleMessage(Exchange exchange) throws HandlerException {
        if (this._responseQueue == null) {
            CommonCommonLogger.ROOT_LOGGER.replyArrivedAfterTimeout(exchange.getConsumer().getName().toString());
        } else {
            try {
                this._responseQueue.put(exchange);
            }
            catch (InterruptedException e) {
                throw new HandlerException((Throwable)e);
            }
        }
    }

    public synchronized void handleFault(Exchange exchange) {
        if (this._responseQueue == null) {
            CommonCommonLogger.ROOT_LOGGER.faultArrivedAfterTimeout(exchange.getConsumer().getName().toString());
        } else {
            try {
                this._responseQueue.put(exchange);
            }
            catch (InterruptedException e) {
                throw CommonCommonMessages.MESSAGES.unexpectedInterruptException(e);
            }
        }
    }
}

