/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.sca.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.naming.InitialContext;
import org.infinispan.Cache;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.common.util.ProviderRegistry;
import org.switchyard.component.sca.NOPEndpointPublisher;
import org.switchyard.component.sca.RemoteEndpointPublisher;
import org.switchyard.component.sca.SCALogger;
import org.switchyard.component.sca.deploy.SCAActivator;
import org.switchyard.config.Configuration;
import org.switchyard.deploy.Activator;
import org.switchyard.deploy.BaseComponent;

public class SCAComponent
extends BaseComponent {
    private static final String CONTEXT_PATH = "switchyard-remote";
    private static final String CACHE_CONTAINER_ROOT = "java:jboss/infinispan/container/";
    private static final String CACHE_NAME_PROPERTY = "cache-name";
    private static final String CACHE_CONFIG_PROPERTY = "cache-config";
    private static final String JGROUPS_CONFIG_PROPERTY = "jgroups-config";
    private static final String DISABLE_REMOTE_TRANSACTION_PROPERTY = "disable-remote-transaction";
    private Logger _log = Logger.getLogger(SCAComponent.class);
    private RemoteEndpointPublisher _endpointPublisher;
    private String _cacheName;
    private Cache<String, String> _cache;
    private boolean _disableRemoteTransaction = false;

    public SCAComponent() {
        super(SCAActivator.TYPES);
        this.setName("RemoteComponent");
        try {
            this.initEndpointPublisher();
        }
        catch (Exception ex) {
            SCALogger.ROOT_LOGGER.failedToInitializeRemoteEndpointPublisher(ex);
        }
    }

    public void init(Configuration environment) {
        Configuration bridgeRemoteTxConfig;
        Configuration cacheFileConfig;
        super.init(environment);
        this._cacheName = "cluster";
        Configuration cacheNameConfig = environment.getFirstChild(CACHE_NAME_PROPERTY);
        if (cacheNameConfig != null) {
            this._cacheName = cacheNameConfig.getValue();
        }
        if ((cacheFileConfig = environment.getFirstChild(CACHE_CONFIG_PROPERTY)) != null && cacheFileConfig.getValue() != null) {
            Configuration jgroupsConfig = environment.getFirstChild(JGROUPS_CONFIG_PROPERTY);
            this.createCache(cacheFileConfig.getValue(), this._cacheName, jgroupsConfig != null ? jgroupsConfig.getValue() : null);
        }
        if ((bridgeRemoteTxConfig = environment.getFirstChild(DISABLE_REMOTE_TRANSACTION_PROPERTY)) != null) {
            this._disableRemoteTransaction = Boolean.parseBoolean(bridgeRemoteTxConfig.getValue());
        }
    }

    public Activator createActivator(ServiceDomain domain) {
        if (this._cache == null) {
            this.lookupCache(this._cacheName);
            if (this._cache == null) {
                SCALogger.ROOT_LOGGER.unableToResolveCacheContainer(this._cacheName);
            }
        }
        SCAActivator activator = new SCAActivator(this._cache);
        activator.setServiceDomain(domain);
        activator.setEndpointPublisher(this._endpointPublisher);
        activator.setDisableRemoteTransaction(this._disableRemoteTransaction);
        return activator;
    }

    public synchronized void destroy() {
        try {
            this._endpointPublisher.stop();
        }
        catch (Exception ex) {
            SCALogger.ROOT_LOGGER.failedToDestroyRemoteEndpointPublisher(ex);
        }
    }

    private void initEndpointPublisher() {
        this._endpointPublisher = (RemoteEndpointPublisher)ProviderRegistry.getProvider(RemoteEndpointPublisher.class);
        if (this._endpointPublisher == null) {
            this._endpointPublisher = new NOPEndpointPublisher();
            SCALogger.ROOT_LOGGER.noEndpointPublisherRegistered();
        }
        this._endpointPublisher.init(CONTEXT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCache(String cacheConfig, String cacheName, String jgroupsConfig) {
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            InputStream configStream = null;
            try {
                File f = new File(cacheConfig);
                configStream = f.exists() && f.isFile() ? new FileInputStream(f) : SCAActivator.class.getClassLoader().getResourceAsStream(cacheConfig);
                ClassLoader cacheClassLoader = DefaultCacheManager.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(cacheClassLoader);
                ConfigurationBuilderHolder holder = new ParserRegistry(cacheClassLoader).parse(configStream);
                if (jgroupsConfig != null) {
                    holder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", jgroupsConfig);
                }
                this._cache = new DefaultCacheManager(holder, true).getCache(cacheName);
            }
            finally {
                if (configStream != null) {
                    try {
                        configStream.close();
                    }
                    catch (Exception e) {
                        e.fillInStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            this._log.debug((Object)"Failed to create cache for distributed registry", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    private void lookupCache(String cacheName) {
        try {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)new InitialContext().lookup(CACHE_CONTAINER_ROOT + cacheName);
            this._cache = cm.getCache();
        }
        catch (Exception ex) {
            this._log.debug((Object)"Failed to lookup cache container for distributed registry", (Throwable)ex);
        }
    }
}

