/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.flatfile.regex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.milyn.flatfile.regex.RegexParserFactory;
import org.milyn.flatfile.variablefield.VariableFieldRecordParser;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexParser<T extends RegexParserFactory>
extends VariableFieldRecordParser<T> {
    private BufferedReader reader;
    private StringBuilder readerBuffer;
    private int groupCount;

    @Override
    public void setDataSource(InputSource source) {
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            throw new IllegalStateException("Invalid InputSource type supplied to RegexParser.  Must contain a Reader instance.");
        }
        this.reader = new BufferedReader(reader);
        this.readerBuffer = new StringBuilder();
        this.groupCount = ((RegexParserFactory)this.getFactory()).getRegexPattern().matcher("").groupCount();
    }

    @Override
    public List<String> nextRecordFieldValues() throws IOException {
        RegexParserFactory factory = (RegexParserFactory)this.getFactory();
        Pattern pattern = factory.getRegexPattern();
        this.readerBuffer.setLength(0);
        factory.readRecord(this.reader, this.readerBuffer, this.getRecordCount() + 1);
        if (this.readerBuffer.length() == 0) {
            return null;
        }
        if (this.groupCount > 0) {
            String recordString = this.readerBuffer.toString();
            ArrayList<String> fields = new ArrayList<String>();
            Matcher matcher = pattern.matcher(recordString);
            if (matcher.matches()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    String fieldValue = matcher.group(i + 1);
                    if (fieldValue == null) continue;
                    fields.add(fieldValue);
                }
            } else {
                fields.add(recordString);
            }
            return fields;
        }
        return Arrays.asList(pattern.split(this.readerBuffer.toString()));
    }
}

