/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.services;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.switchyard.common.lang.Strings;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.crypto.PrivateCrypto;
import org.switchyard.security.crypto.PublicCrypto;
import org.switchyard.security.system.DefaultSystemSecurity;
import org.switchyard.security.system.SystemSecurity;

public class SwitchYardSecurityConfigService
implements Service<SecurityConfig> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"SwitchYardSecurityConfigService"});
    private final InjectedValue<SystemSecurity> _systemSecurity = new InjectedValue();
    private final InjectedValue<Map> _injectedValues = new InjectedValue();
    private String _moduleId;
    private ModelNode _model;
    private SecurityConfig _securityConfig;

    public SwitchYardSecurityConfigService(String moduleId, ModelNode model) {
        this._moduleId = moduleId;
        this._model = model;
    }

    public SecurityConfig getValue() throws IllegalStateException, IllegalArgumentException {
        return this._securityConfig;
    }

    public void start(StartContext context) throws StartException {
        String timeoutMillis;
        ModelNode propertiesModel = this._model.hasDefined("properties") ? this._model.get("properties") : null;
        Properties securityProps = this.toProperties(propertiesModel);
        this._securityConfig = new SecurityConfig(securityProps);
        DefaultSystemSecurity systemSecurity = (DefaultSystemSecurity)this.getSystemSecurity().getValue();
        if (SecurityContext.class.getName().equals(this._moduleId) && (timeoutMillis = Strings.trimToNull((String)securityProps.getProperty("timeoutMillis"))) != null) {
            systemSecurity.setSecurityContextTimeoutMillis(Long.valueOf(timeoutMillis));
        }
        if (PrivateCrypto.class.getName().equals(this._moduleId)) {
            systemSecurity.setPrivateCrypto(new PrivateCrypto(securityProps));
        }
        if (PublicCrypto.class.getName().equals(this._moduleId)) {
            systemSecurity.setPublicCrypto(new PublicCrypto(securityProps));
        }
    }

    private Properties toProperties(ModelNode propertiesModel) {
        Set names;
        Properties properties = new Properties();
        if (propertiesModel != null && (names = propertiesModel.keys()) != null) {
            for (String name : names) {
                String value = propertiesModel.get(name).asString();
                if (value.startsWith("$")) {
                    String key = value.substring(1);
                    String injectedValue = (String)((Map)this._injectedValues.getValue()).get(key);
                    if (injectedValue == null) continue;
                    properties.setProperty(name, injectedValue);
                    continue;
                }
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    public void stop(StopContext context) {
    }

    public InjectedValue<SystemSecurity> getSystemSecurity() {
        return this._systemSecurity;
    }

    public InjectedValue<Map> getInjectedValues() {
        return this._injectedValues;
    }

    public static final class SecurityConfig {
        private final Properties _properties;

        public SecurityConfig(Properties properties) {
            this._properties = properties;
        }

        public Properties getProperties() {
            return this._properties;
        }
    }
}

