/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.system;

import java.util.UUID;
import org.switchyard.security.crypto.PrivateCrypto;
import org.switchyard.security.crypto.PublicCrypto;
import org.switchyard.security.system.SystemSecurity;

public class DefaultSystemSecurity
implements SystemSecurity {
    private static final String FORMAT = DefaultSystemSecurity.class.getSimpleName() + "@%s[uuid=%s, securityContextTimeoutMillis=%s, privateCrypto=%s, publicCrypto=%s]";
    private final UUID _uuid = UUID.randomUUID();
    private Long _securityContextTimeoutMillis;
    private PrivateCrypto _privateCrypto;
    private PublicCrypto _publicCrypto;

    public DefaultSystemSecurity() {
        this(null, null, null);
    }

    public DefaultSystemSecurity(Long securityContextTimeoutMillis, PrivateCrypto privateCrypto, PublicCrypto publicCrypto) {
        this._securityContextTimeoutMillis = securityContextTimeoutMillis;
        this._privateCrypto = privateCrypto;
        this._publicCrypto = publicCrypto;
    }

    @Override
    public UUID getUUID() {
        return this._uuid;
    }

    @Override
    public Long getSecurityContextTimeoutMillis() {
        return this._securityContextTimeoutMillis;
    }

    public void setSecurityContextTimeoutMillis(Long securityContextTimeoutMillis) {
        this._securityContextTimeoutMillis = securityContextTimeoutMillis;
    }

    @Override
    public PrivateCrypto getPrivateCrypto() {
        return this._privateCrypto;
    }

    public void setPrivateCrypto(PrivateCrypto privateCrypto) {
        this._privateCrypto = privateCrypto;
    }

    @Override
    public PublicCrypto getPublicCrypto() {
        return this._publicCrypto;
    }

    public void setPublicCrypto(PublicCrypto publicCrypto) {
        this._publicCrypto = publicCrypto;
    }

    public String toString() {
        return String.format(FORMAT, System.identityHashCode(this), this._uuid, this._securityContextTimeoutMillis, this._privateCrypto, this._publicCrypto);
    }

    static final class ImmutableDefaultSystemSecurity
    extends DefaultSystemSecurity {
        ImmutableDefaultSystemSecurity() {
        }

        @Override
        public void setSecurityContextTimeoutMillis(Long securityContextTimeoutMillis) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrivateCrypto(PrivateCrypto privateCrypto) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPublicCrypto(PublicCrypto publicCrypto) {
            throw new UnsupportedOperationException();
        }
    }
}

