/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.migration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.IMAManager;
import org.apache.ode.bpel.engine.OutstandingRequestManager;
import org.apache.ode.bpel.engine.migration.Migration;
import org.apache.ode.dao.bpel.BpelDAOConnection;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;

public class OutstandingRequestsMigration
implements Migration {
    private static Log __log = LogFactory.getLog(OutstandingRequestsMigration.class);

    @Override
    public boolean migrate(Set<BpelProcess> registeredProcesses, BpelDAOConnection connection) {
        boolean migrationResult = true;
        for (BpelProcess process : registeredProcesses) {
            ProcessDAO processDao = connection.getProcess(process.getConf().getProcessId());
            Collection pis = processDao.getActiveInstances();
            for (ProcessInstanceDAO instance : pis) {
                __log.debug((Object)("Migrating outstanding requests for instance " + instance.getInstanceId()));
                try {
                    if (instance.getExecutionState() == null) {
                        __log.debug((Object)"Skipped");
                        continue;
                    }
                    ExecutionQueueImpl soup = new ExecutionQueueImpl(this.getClass().getClassLoader());
                    soup.setReplacementMap(process.getReplacementMap(processDao.getProcessId()));
                    soup.read((InputStream)new ByteArrayInputStream(instance.getExecutionState()));
                    Serializable data = soup.getGlobalData();
                    if (!(data instanceof OutstandingRequestManager)) continue;
                    OutstandingRequestManager orm = (OutstandingRequestManager)data;
                    IMAManager imaManager = new IMAManager();
                    imaManager.migrateRids(orm.getRids());
                    soup.setGlobalData((Serializable)imaManager);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    soup.write((OutputStream)bos);
                    instance.setExecutionState(bos.toByteArray());
                    __log.debug((Object)("Migrated outstanding requests for instance " + instance.getInstanceId()));
                }
                catch (Exception e) {
                    __log.debug((Object)"", (Throwable)e);
                    __log.error((Object)("Error migrating outstanding requests for instance " + instance.getInstanceId()));
                    migrationResult = false;
                }
            }
        }
        return migrationResult;
    }
}

