/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.memdao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.memdao.BpelDAOConnectionImpl;
import org.apache.ode.bpel.memdao.CorrelatorDaoImpl;
import org.apache.ode.bpel.memdao.DaoBaseImpl;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.CorrelatorDAO;
import org.apache.ode.dao.bpel.PartnerLinkDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;

class ProcessDaoImpl
extends DaoBaseImpl
implements ProcessDAO {
    private static final Log __log = LogFactory.getLog(ProcessDaoImpl.class);
    private QName _processId;
    private QName _type;
    private long _version;
    final Map<String, CorrelatorDaoImpl> _correlators = new ConcurrentHashMap<String, CorrelatorDaoImpl>();
    protected final Map<Long, ProcessInstanceDAO> _instances = new ConcurrentHashMap<Long, ProcessInstanceDAO>();
    protected final Map<Long, Long> _instancesAge = new ConcurrentHashMap<Long, Long>();
    protected final Map<Integer, PartnerLinkDAO> _plinks = new ConcurrentHashMap<Integer, PartnerLinkDAO>();
    private Map<QName, ProcessDaoImpl> _store;
    private BpelDAOConnectionImpl _conn;
    private int _executionCount = 0;
    private Collection<Long> _instancesToRemove = new ConcurrentLinkedQueue<Long>();
    private volatile long _lastRemoval = 0L;
    private String _guid;

    public ProcessDaoImpl(BpelDAOConnectionImpl conn, Map<QName, ProcessDaoImpl> store, QName processId, QName type, String guid, long version) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Creating ProcessDao object for process \"" + processId + "\"."));
        }
        this._guid = guid;
        this._conn = conn;
        this._store = store;
        this._processId = processId;
        this._type = type;
        this._version = version;
    }

    public Serializable getId() {
        return this._guid;
    }

    public QName getProcessId() {
        return this._processId;
    }

    public CorrelatorDAO getCorrelator(String cid) {
        CorrelatorDAO ret = this._correlators.get(cid);
        if (ret == null) {
            throw new IllegalArgumentException("no such correlator: " + cid);
        }
        return ret;
    }

    public Collection<CorrelatorDAO> getCorrelators() {
        Collection<CorrelatorDaoImpl> foo = this._correlators.values();
        return Collections.unmodifiableCollection(foo);
    }

    public void removeRoutes(String routeId, ProcessInstanceDAO target) {
        for (CorrelatorDAO correlatorDAO : this._correlators.values()) {
            correlatorDAO.removeRoutes(routeId, target);
        }
    }

    public ProcessInstanceDAO createInstance(CorrelatorDAO correlator) {
        final ProcessInstanceDaoImpl newInstance = new ProcessInstanceDaoImpl(this._conn, this, correlator);
        this._conn.defer(new Runnable(){

            @Override
            public void run() {
                ProcessDaoImpl.this._instances.put(newInstance.getInstanceId(), newInstance);
                ProcessDaoImpl.this._instancesAge.put(newInstance.getInstanceId(), System.currentTimeMillis());
            }
        });
        this.discardOldInstances();
        final Long iid = newInstance.getInstanceId();
        this._conn.onRollback(new Runnable(){

            @Override
            public void run() {
                ProcessDaoImpl.this._instances.remove(iid);
                ProcessDaoImpl.this._instancesAge.remove(iid);
            }
        });
        ++this._executionCount;
        return newInstance;
    }

    public ProcessInstanceDAO getInstance(Long instanceId) {
        return this._instances.get(instanceId);
    }

    public Collection<ProcessInstanceDAO> findInstance(CorrelationKey key) {
        ArrayList<ProcessInstanceDAO> result = new ArrayList<ProcessInstanceDAO>();
        for (ProcessInstanceDAO instance : this._instances.values()) {
            for (CorrelationSetDAO corrSet : instance.getCorrelationSets()) {
                if (!corrSet.getValue().equals((Object)key)) continue;
                result.add(instance);
            }
        }
        return result;
    }

    public void instanceCompleted(ProcessInstanceDAO instance) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Removing completed process instance " + instance.getInstanceId() + " from in-memory store."));
        }
        this._instancesAge.remove(instance.getInstanceId());
        ProcessInstanceDAO removed = this._instances.remove(instance.getInstanceId());
        if (removed == null) {
            ArrayList<Long> removals = new ArrayList<Long>(this._instancesToRemove);
            for (Long iid : removals) {
                this._instances.remove(iid);
            }
            this._instancesToRemove.removeAll(removals);
            this._instancesToRemove.add(instance.getInstanceId());
        }
    }

    public void deleteProcessAndRoutes() {
        this._store.remove(this._processId);
    }

    public long getVersion() {
        return this._version;
    }

    public String getDeployer() {
        return "nobody";
    }

    public QName getType() {
        return this._type;
    }

    public CorrelatorDAO addCorrelator(String correlator) {
        CorrelatorDaoImpl corr = new CorrelatorDaoImpl(correlator, this._conn);
        this._correlators.put(corr.getCorrelatorId(), corr);
        return corr;
    }

    public void update() {
    }

    public int getNumInstances() {
        return this._executionCount;
    }

    public ProcessInstanceDAO getInstanceWithLock(Long iid) {
        return this.getInstance(iid);
    }

    public int getActivityFailureCount() {
        return 0;
    }

    public Date getActivityFailureDateTime() {
        return null;
    }

    public String getGuid() {
        return this._guid;
    }

    public void setGuid(String guid) {
        this._guid = guid;
    }

    public Collection<ProcessInstanceDAO> getActiveInstances() {
        ArrayList<ProcessInstanceDAO> pis = new ArrayList<ProcessInstanceDAO>();
        for (ProcessInstanceDAO processInstanceDAO : this._instances.values()) {
            if (processInstanceDAO.getState() != 20) continue;
            pis.add(processInstanceDAO);
        }
        return pis;
    }

    void discardOldInstances() {
        long now = System.currentTimeMillis();
        if (now > this._lastRemoval + this._conn._mexTtl / 10L) {
            this._lastRemoval = now;
            Object[] oldInstances = this._instancesAge.keySet().toArray();
            for (int i = oldInstances.length - 1; i >= 0; --i) {
                Long id = (Long)oldInstances[i];
                Long age = this._instancesAge.get(id);
                if (age == null || now - age <= this._conn._mexTtl) continue;
                if (this._instances.get(id) != null) {
                    __log.warn((Object)("Discarding in-memory instance " + id + " because it exceeded its time-to-live: " + this._instances.get(id)));
                }
                this._instances.remove(id);
                this._instancesAge.remove(id);
            }
        }
    }
}

