/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.switchyard;

import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.ServiceReference;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.switchyard.ExchangeMapper;
import org.switchyard.component.camel.switchyard.SwitchYardCamelComponentMessages;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;

public class CamelResponseHandler
implements ExchangeHandler {
    private final org.apache.camel.Exchange _camelExchange;
    private final MessageComposer<CamelBindingData> _messageComposer;

    public CamelResponseHandler(org.apache.camel.Exchange camelExchange, ServiceReference reference, MessageComposer<CamelBindingData> messageComposer) {
        if (camelExchange == null) {
            throw SwitchYardCamelComponentMessages.MESSAGES.camelExchangeArgumentMustNotBeNull();
        }
        if (reference == null) {
            throw SwitchYardCamelComponentMessages.MESSAGES.referenceArgumentMustNotBeNull();
        }
        this._camelExchange = camelExchange;
        this._messageComposer = messageComposer;
    }

    public void handleMessage(Exchange switchYardExchange) throws HandlerException {
        try {
            this.compose(switchYardExchange);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private Message getCamelMessage() {
        return this.isInOnly() ? this._camelExchange.getIn() : this._camelExchange.getOut();
    }

    private boolean isInOnly() {
        return this._camelExchange.getPattern().equals((Object)ExchangePattern.InOnly);
    }

    public void handleFault(Exchange exchange) {
        Object content = exchange.getMessage().getContent();
        if (content instanceof Throwable) {
            this._camelExchange.setException((Throwable)content);
            return;
        }
        try {
            Message camelMsg = this.compose(exchange);
            camelMsg.setFault(true);
        }
        catch (Exception e) {
            this._camelExchange.setException((Throwable)e);
        }
    }

    private Message compose(Exchange exchange) throws Exception {
        Message camelMsg;
        if (this._messageComposer != null) {
            camelMsg = this.getCamelMessage();
            this._messageComposer.decompose(exchange, (BindingData)new CamelBindingData(camelMsg));
        } else {
            camelMsg = ExchangeMapper.mapSwitchYardToCamel(exchange, this._camelExchange);
            if (this.isInOnly()) {
                this._camelExchange.setIn(camelMsg);
            } else {
                this._camelExchange.setOut(camelMsg);
            }
        }
        return camelMsg;
    }
}

