/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.ws;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.soap.DecoupledFaultHandler;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.neethi.Assertion;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.NonSpringBusHolder;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreatingInterceptor;
import org.jboss.wsf.stack.cxf.security.authentication.SubjectCreatingPolicyInterceptor;
import org.switchyard.as7.extension.ExtensionMessages;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.type.reflect.FieldAccess;
import org.switchyard.component.soap.AddressingInterceptor;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.config.model.InterceptorModel;
import org.switchyard.component.soap.config.model.InterceptorsModel;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.config.model.property.PropertiesModel;
import org.switchyard.security.credential.ConfidentialityCredential;

public final class Interceptors {
    private static final String SLASH_STR = "/";
    private static final String QUESTION_MARK_STR = "?";
    private static final String QUESTION_MARK_REGEXP_STR = "\\?";
    private static final String NULL_STR = "null";
    private static final String HTTP_POST = "POST";
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{Map.class}, new Class[0]};

    public static void addInterceptors(org.jboss.wsf.spi.deployment.Endpoint endpoint, SOAPBindingModel bindingModel, ClassLoader loader) {
        BusHolder busHolder = (BusHolder)endpoint.getService().getDeployment().getAttachment(BusHolder.class);
        if (busHolder instanceof NonSpringBusHolder) {
            List list = (List)new FieldAccess(NonSpringBusHolder.class, "endpoints").read((Object)busHolder);
            for (Object o : list) {
                for (Endpoint e : ((EndpointImpl)o).getService().getEndpoints().values()) {
                    Interceptors.checkAddressingEnabled(e);
                    e.getInInterceptors().add(new SwitchYardURIMappingInterceptor());
                    e.getInInterceptors().add(new SwitchYardDispatchInterceptor());
                    e.getInInterceptors().add(new SwitchYardEncryptionConfidentialityInterceptor());
                    e.getInInterceptors().addAll(Interceptors.getConfiguredInInterceptors(bindingModel, loader));
                    e.getOutInterceptors().addAll(Interceptors.getConfiguredOutInterceptors(bindingModel, loader));
                    e.getOutInterceptors().add(new SwitchYardSecurityCleanupOutInterceptor());
                    e.getOutFaultInterceptors().add(new SwitchYardSecurityCleanupOutFaultInterceptor());
                }
            }
        }
    }

    private static void checkAddressingEnabled(Endpoint e) {
        for (Feature feature : e.getActiveFeatures()) {
            if (!(feature instanceof WSAddressingFeature)) continue;
            e.getInInterceptors().add(new DecoupledFaultHandler());
            e.getOutInterceptors().add(new AddressingInterceptor());
            e.getOutFaultInterceptors().add(new AddressingInterceptor());
            break;
        }
    }

    public static <T extends Interceptor<? extends Message>> List<T> getConfiguredInInterceptors(SOAPBindingModel bindingModel, ClassLoader loader) {
        if (bindingModel != null) {
            return Interceptors.getConfiguredInterceptors(bindingModel.getInInterceptors(), loader);
        }
        return null;
    }

    public static <T extends Interceptor<? extends Message>> List<T> getConfiguredOutInterceptors(SOAPBindingModel bindingModel, ClassLoader loader) {
        if (bindingModel != null) {
            return Interceptors.getConfiguredInterceptors(bindingModel.getOutInterceptors(), loader);
        }
        return null;
    }

    private static <T extends Interceptor<? extends Message>> List<T> getConfiguredInterceptors(InterceptorsModel interceptorsModel, ClassLoader loader) {
        ArrayList<T> interceptors = new ArrayList<T>();
        if (interceptorsModel != null) {
            for (InterceptorModel interceptorModel : interceptorsModel.getInterceptors()) {
                PropertiesModel propertiesModel;
                Map properties;
                T interceptor;
                Class interceptorClass;
                if (interceptorModel == null || (interceptorClass = interceptorModel.getClazz(loader)) == null || (interceptor = Interceptors.newInterceptor(interceptorClass, properties = (propertiesModel = interceptorModel.getProperties()) != null ? propertiesModel.toMap() : new HashMap())) == null) continue;
                if (interceptor instanceof SubjectCreatingInterceptor) {
                    ((SubjectCreatingInterceptor)interceptor).setPropagateContext(true);
                } else if (interceptor instanceof SubjectCreatingPolicyInterceptor) {
                    ((SubjectCreatingPolicyInterceptor)interceptor).setPropagateContext(true);
                }
                interceptors.add(interceptor);
            }
        }
        return interceptors;
    }

    private static <T extends Interceptor<? extends Message>> T newInterceptor(Class<T> interceptorClass, Map<String, String> properties) {
        Interceptor interceptor = null;
        Constructor<T> constructor = Interceptors.getConstructor(interceptorClass);
        Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
        try {
            if (parameterTypes.length == 0) {
                interceptor = (Interceptor)Construction.construct(interceptorClass);
            } else if (parameterTypes.length == 1) {
                interceptor = (Interceptor)Construction.construct(interceptorClass, (Class[])parameterTypes, (Object[])new Object[]{properties});
            }
        }
        catch (Throwable t) {
            throw ExtensionMessages.MESSAGES.couldNotInstantiateInterceptor(interceptorClass.getName(), t);
        }
        return (T)interceptor;
    }

    private static <T extends Interceptor<? extends Message>> Constructor<T> getConstructor(Class<T> interceptorClass) {
        Constructor<T> constructor = null;
        for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
            try {
                constructor = interceptorClass.getConstructor(parameterTypes);
                if (constructor == null) continue;
                break;
            }
            catch (Throwable t) {
                t.getMessage();
            }
        }
        return constructor;
    }

    private Interceptors() {
    }

    private static final class SwitchYardSecurityCleanupOutFaultInterceptor
    extends SwitchYardSecurityCleanupInterceptor {
        private SwitchYardSecurityCleanupOutFaultInterceptor() {
        }
    }

    private static final class SwitchYardSecurityCleanupOutInterceptor
    extends SwitchYardSecurityCleanupInterceptor {
        private SwitchYardSecurityCleanupOutInterceptor() {
        }
    }

    private static final class SwitchYardURIMappingInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private SwitchYardURIMappingInterceptor() {
            super("pre-protocol");
        }

        public void handleMessage(Message message) throws Fault {
            String rest;
            String opName;
            String method = (String)message.get((Object)"org.apache.cxf.request.method");
            if (method.equals(Interceptors.HTTP_POST)) {
                return;
            }
            String path = (String)message.get((Object)Message.PATH_INFO);
            String basePath = (String)message.get((Object)Message.BASE_PATH);
            if (basePath == null) {
                basePath = Interceptors.SLASH_STR;
            }
            if ((opName = StringUtils.getFirstNotEmpty((String)(rest = StringUtils.diff((String)path, (String)basePath)), (String)Interceptors.SLASH_STR)).indexOf(Interceptors.QUESTION_MARK_STR) != -1) {
                opName = opName.split(Interceptors.QUESTION_MARK_REGEXP_STR)[0];
            }
            if (opName == null || opName.equals(Interceptors.NULL_STR)) {
                String pathInfo = (String)message.get((Object)Message.PATH_INFO);
                if (!(pathInfo = pathInfo.split(Interceptors.NULL_STR)[0]).endsWith(Interceptors.SLASH_STR)) {
                    pathInfo = pathInfo.concat(Interceptors.SLASH_STR);
                }
                throw new Fault((Throwable)ExtensionMessages.MESSAGES.noSuchOperationGet(method, pathInfo));
            }
        }
    }

    private static final class SwitchYardDispatchInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private SwitchYardDispatchInterceptor() {
            super("post-protocol");
        }

        public void handleMessage(Message message) throws Fault {
            message.setContextualProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, (Object)true);
        }
    }

    private static class SwitchYardSecurityCleanupInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private SwitchYardSecurityCleanupInterceptor() {
            super("post-logical-ending");
        }

        public void handleMessage(Message message) throws Fault {
            InboundHandler.unsetCredentials();
            SecurityContextAssociation.clearSecurityContext();
        }

        public void handleFault(Message message) {
            InboundHandler.unsetCredentials();
            SecurityContextAssociation.clearSecurityContext();
        }
    }

    private static final class SwitchYardEncryptionConfidentialityInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private SwitchYardEncryptionConfidentialityInterceptor() {
            super("post-protocol");
            this.getAfter().add(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            Collection ais;
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            if (aim != null && (ais = aim.getAssertionInfo(SP12Constants.ENCRYPTED_PARTS)) != null) {
                for (AssertionInfo ai : ais) {
                    SignedEncryptedParts sep;
                    Assertion a = ai.getAssertion();
                    if (!(a instanceof SignedEncryptedParts) || (sep = (SignedEncryptedParts)a).isIgnorable() || sep.isOptional()) continue;
                    InboundHandler.getCredentials().add(new ConfidentialityCredential(true));
                    break;
                }
            }
        }
    }
}

