/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.bus.camel;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.jboss.logging.Logger;
import org.switchyard.Context;
import org.switchyard.Message;
import org.switchyard.bus.camel.BusMessages;
import org.switchyard.bus.camel.CamelCompositeContext;
import org.switchyard.common.camel.HandlerDataSource;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.camel.SwitchYardMessage;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public class CamelMessage
extends SwitchYardMessage
implements Message {
    private static Logger _logger = Logger.getLogger(CamelMessage.class);

    public CamelMessage(Exchange exchange) {
        this.setExchange(exchange);
    }

    public Message setContent(Object content) {
        this.setBody(content);
        return this;
    }

    public Object getContent() {
        return this.getBody();
    }

    public <T> T getContent(Class<T> type) {
        return (T)this.getBody(type);
    }

    protected <T> T getBody(Class<T> type, Object body) {
        Object transformedContent;
        Transformer transformer;
        if (type == null) {
            throw BusMessages.MESSAGES.nullTypeArgument();
        }
        if (body == null) {
            return null;
        }
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        TransformerRegistry transformerRegistry = this.getTransformerRegistry();
        if (transformerRegistry == null) {
            throw BusMessages.MESSAGES.cannotConvertNoTransformRegistry(body.getClass().getName(), type.getName());
        }
        QName toType = JavaTypes.toMessageType(type);
        QName fromType = JavaTypes.toMessageType(body.getClass());
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Looking for a transformer:[from='" + fromType + "', to='" + toType + "']"));
        }
        if ((transformer = transformerRegistry.getTransformer(fromType, toType)) == null) {
            Object camelBody;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"No suitable transformer in registry. Trying camel converters for next.");
            }
            if ((camelBody = super.getBody(type, body)) == null) {
                throw BusMessages.MESSAGES.transformerMustBeRegistered(body.getClass().getName(), type.getName(), fromType.toString(), toType.toString());
            }
            return (T)camelBody;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Applying a transformer:[from='" + fromType + "', to='" + toType + "', class=" + transformer.getClass() + "'] to the body '" + body + "'"));
        }
        if ((transformedContent = transformer.transform(body)) == null) {
            throw BusMessages.MESSAGES.transformerReturnedNull(body.getClass().getName(), type.getName(), transformer.getClass().getName());
        }
        if (!type.isInstance(transformedContent)) {
            throw BusMessages.MESSAGES.transformerReturnedIncompatibleType(body.getClass().getName(), type.getName(), transformer.getClass().getName(), transformedContent.getClass().getName());
        }
        return type.cast(transformedContent);
    }

    public Message addAttachment(String name, DataSource attachment) {
        this.addAttachment(name, new DataHandler(attachment));
        return this;
    }

    public HandlerDataSource getAttachment(String name) {
        DataHandler attachement = super.getAttachment(name);
        return attachement != null ? new HandlerDataSource(attachement) : null;
    }

    public void removeAttachment(String name) {
        HandlerDataSource attachment = this.getAttachment(name);
        if (attachment != null) {
            super.removeAttachment(name);
        }
    }

    public Map<String, DataSource> getAttachmentMap() {
        HashMap<String, DataSource> attachements = new HashMap<String, DataSource>();
        for (Map.Entry attachement : this.getAttachments().entrySet()) {
            attachements.put((String)attachement.getKey(), ((DataHandler)attachement.getValue()).getDataSource());
        }
        return attachements;
    }

    public Context getContext() {
        return new CamelCompositeContext(this.getExchange(), (org.apache.camel.Message)this);
    }

    public CamelMessage copy() {
        CamelMessage message = this.newInstance();
        message.setBody(this.getBody());
        return message;
    }

    public CamelMessage newInstance() {
        return new CamelMessage(this.getExchange());
    }

    public void sent() {
        this.getContext().setProperty("org.switchyard.bus.camel.messageSent", (Object)true).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
    }

    public boolean isSent() {
        return (Boolean)this.getHeader("org.switchyard.bus.camel.messageSent", false, Boolean.class);
    }

    private TransformerRegistry getTransformerRegistry() {
        CamelContext context = this.getExchange().getContext();
        if (context instanceof SwitchYardCamelContext) {
            return ((SwitchYardCamelContext)context).getServiceDomain().getTransformerRegistry();
        }
        return null;
    }
}

