/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.cxf.model.v2;

import java.net.URI;
import java.util.List;
import org.switchyard.component.camel.common.QueryString;
import org.switchyard.component.camel.common.model.v1.V1BaseCamelBindingModel;
import org.switchyard.component.camel.cxf.model.CamelCxfBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;

public class V2CamelCxfBindingModel
extends V1BaseCamelBindingModel
implements CamelCxfBindingModel {
    public static final String CXF = "cxf";
    private static final String CXFURI = "cxfURI";
    private static final String WSDLURL = "wsdlURL";
    private static final String SERVICECLASS = "serviceClass";
    private static final String SERVICENAME = "serviceName";
    private static final String PORTNAME = "portName";
    private static final String DATAFORMAT = "dataFormat";
    private static final String RELAYHEADERS = "relayHeaders";
    private static final String WRAPPED = "wrapped";
    private static final String WRAPPEDSTYLE = "wrappedStyle";
    private static final String SETDEFAULTBUS = "setDefaultBus";
    private static final String BUS = "bus";
    private static final String CXFBINDING = "cxfBinding";
    private static final String HEADERFILTERSTRATEGY = "headerFilterStrategy";
    private static final String LOGGINGFEATUREENABLED = "loggingFeatureEnabled";
    private static final String DEFAULTOPERATIONNAME = "defaultOperationName";
    private static final String DEFAULTOPERATIONNAMESPACE = "defaultOperationNamespace";
    private static final String SYNCHRONOUS = "synchronous";
    private static final String PUBLISHEDENDPOINTURL = "publishedEndpointUrl";
    private static final String ALLOWSTREAMING = "allowStreaming";
    private static final String SKIPFAULTLOGGING = "skipFaultLogging";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    public V2CamelCxfBindingModel(String namespace) {
        super(CXF, namespace);
        this.setModelChildrenOrder(new String[]{CXFURI, WSDLURL, SERVICECLASS, SERVICENAME, PORTNAME, DATAFORMAT, RELAYHEADERS, WRAPPED, WRAPPEDSTYLE, SETDEFAULTBUS, BUS, CXFBINDING, HEADERFILTERSTRATEGY, LOGGINGFEATUREENABLED, DEFAULTOPERATIONNAME, DEFAULTOPERATIONNAMESPACE, SYNCHRONOUS, PUBLISHEDENDPOINTURL, ALLOWSTREAMING, SKIPFAULTLOGGING, USERNAME, PASSWORD});
    }

    public V2CamelCxfBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
    }

    @Override
    public URI getCxfURI() {
        String uriStr = this.getConfig(CXFURI);
        if (uriStr != null) {
            return URI.create(uriStr);
        }
        return null;
    }

    @Override
    public V2CamelCxfBindingModel setCxfURI(URI cxfURI) {
        this.setConfig(CXFURI, cxfURI);
        return this;
    }

    @Override
    public String getWsdlURL() {
        return this.getConfig(WSDLURL);
    }

    @Override
    public V2CamelCxfBindingModel setWsdlURL(String wsdlURL) {
        this.setConfig(WSDLURL, wsdlURL);
        return this;
    }

    @Override
    public String getServiceClass() {
        return this.getConfig(SERVICECLASS);
    }

    @Override
    public V2CamelCxfBindingModel setServiceClass(String serviceClass) {
        this.setConfig(SERVICECLASS, serviceClass);
        return this;
    }

    @Override
    public String getServiceName() {
        return this.getConfig(SERVICENAME);
    }

    @Override
    public V2CamelCxfBindingModel setServiceName(String serviceName) {
        this.setConfig(SERVICENAME, serviceName);
        return this;
    }

    @Override
    public String getPortName() {
        return this.getConfig(PORTNAME);
    }

    @Override
    public V2CamelCxfBindingModel setPortName(String portName) {
        this.setConfig(PORTNAME, portName);
        return this;
    }

    @Override
    public String getDataFormat() {
        return this.getConfig(DATAFORMAT);
    }

    @Override
    public V2CamelCxfBindingModel setDataFormat(String dataFormat) {
        this.setConfig(DATAFORMAT, dataFormat);
        return this;
    }

    @Override
    public Boolean isRelayHeaders() {
        return this.getBooleanConfig(RELAYHEADERS);
    }

    @Override
    public V2CamelCxfBindingModel setRelayHeaders(Boolean relayHeaders) {
        this.setConfig(RELAYHEADERS, relayHeaders);
        return this;
    }

    @Override
    public Boolean isWrapped() {
        return this.getBooleanConfig(WRAPPED);
    }

    @Override
    public V2CamelCxfBindingModel setWrapped(Boolean wrapped) {
        this.setConfig(WRAPPED, wrapped);
        return this;
    }

    @Override
    public Boolean isWrappedStyle() {
        return this.getBooleanConfig(WRAPPEDSTYLE);
    }

    @Override
    public V2CamelCxfBindingModel setWrappedStyle(Boolean wrappedStyle) {
        this.setConfig(WRAPPEDSTYLE, wrappedStyle);
        return this;
    }

    @Override
    public Boolean isSetDefaultBus() {
        return this.getBooleanConfig(SETDEFAULTBUS);
    }

    @Override
    public V2CamelCxfBindingModel setSetDefaultBus(Boolean setDefaultBus) {
        this.setConfig(SETDEFAULTBUS, setDefaultBus);
        return this;
    }

    @Override
    public String getBus() {
        return this.getConfig(BUS);
    }

    @Override
    public V2CamelCxfBindingModel setBus(String bus) {
        this.setConfig(BUS, bus);
        return this;
    }

    @Override
    public String getCxfBinding() {
        return this.getConfig(CXFBINDING);
    }

    @Override
    public V2CamelCxfBindingModel setCxfBinding(String cxfBinding) {
        this.setConfig(CXFBINDING, cxfBinding);
        return this;
    }

    @Override
    public String getHeaderFilterStrategy() {
        return this.getConfig(HEADERFILTERSTRATEGY);
    }

    @Override
    public V2CamelCxfBindingModel setHeaderFilterStrategy(String headerFilterStrategy) {
        this.setConfig(HEADERFILTERSTRATEGY, headerFilterStrategy);
        return this;
    }

    @Override
    public Boolean isLoggingFeatureEnabled() {
        return this.getBooleanConfig(LOGGINGFEATUREENABLED);
    }

    @Override
    public V2CamelCxfBindingModel setLoggingFeatureEnabled(Boolean loggingFeatureEnabled) {
        this.setConfig(LOGGINGFEATUREENABLED, loggingFeatureEnabled);
        return this;
    }

    @Override
    public String getDefaultOperationName() {
        return this.getConfig(DEFAULTOPERATIONNAME);
    }

    @Override
    public V2CamelCxfBindingModel setDefaultOperationName(String defaultOperationName) {
        this.setConfig(DEFAULTOPERATIONNAME, defaultOperationName);
        return this;
    }

    @Override
    public String getDefaultOperationNamespace() {
        return this.getConfig(DEFAULTOPERATIONNAMESPACE);
    }

    @Override
    public V2CamelCxfBindingModel setDefaultOperationNamespace(String defaultOperationNamespace) {
        this.setConfig(DEFAULTOPERATIONNAMESPACE, defaultOperationNamespace);
        return this;
    }

    @Override
    public Boolean isSynchronous() {
        return this.getBooleanConfig(SYNCHRONOUS);
    }

    @Override
    public V2CamelCxfBindingModel setSynchronous(Boolean synchronous) {
        this.setConfig(SYNCHRONOUS, synchronous);
        return this;
    }

    @Override
    public String getPublishedEndpointUrl() {
        return this.getConfig(PUBLISHEDENDPOINTURL);
    }

    @Override
    public V2CamelCxfBindingModel setPublishedEndpointUrl(String publishedEndpointUrl) {
        this.setConfig(PUBLISHEDENDPOINTURL, publishedEndpointUrl);
        return this;
    }

    @Override
    public Boolean isAllowStreaming() {
        return this.getBooleanConfig(ALLOWSTREAMING);
    }

    @Override
    public V2CamelCxfBindingModel setAllowStreaming(Boolean allowStreaming) {
        this.setConfig(ALLOWSTREAMING, allowStreaming);
        return this;
    }

    @Override
    public Boolean isSkipFaultLogging() {
        return this.getBooleanConfig(SKIPFAULTLOGGING);
    }

    @Override
    public V2CamelCxfBindingModel setSkipFaultLogging(Boolean skipFaultLogging) {
        this.setConfig(SKIPFAULTLOGGING, skipFaultLogging);
        return this;
    }

    @Override
    public String getUsername() {
        return this.getConfig(USERNAME);
    }

    @Override
    public V2CamelCxfBindingModel setUsername(String username) {
        this.setConfig(USERNAME, username);
        return this;
    }

    @Override
    public String getPassword() {
        return this.getConfig(PASSWORD);
    }

    @Override
    public V2CamelCxfBindingModel setPassword(String password) {
        this.setConfig(PASSWORD, password);
        return this;
    }

    public URI getComponentURI() {
        Configuration modelConfiguration = this.getModelConfiguration();
        List children = modelConfiguration.getChildren();
        String baseUri = "cxf://" + this.getCxfURI();
        QueryString queryStr = new QueryString();
        this.traverseConfiguration(children, queryStr, new String[]{CXFURI});
        return URI.create(baseUri + queryStr.toString());
    }
}

