/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ode.bpel.pmapi.InstanceInfoListDocument;
import org.apache.ode.bpel.pmapi.ProcessInfoListDocument;
import org.apache.ode.bpel.pmapi.TInstanceInfo;
import org.apache.ode.bpel.pmapi.TProcessInfo;
import org.apache.ode.bpel.pmapi.TProcessStatus;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.soa.bpel.console.util.Base64;

public class ModelAdaptor {
    public static List<ProcessDefinitionRef> adoptDefinitions(ProcessInfoListDocument processInfoListDocument) {
        ArrayList<ProcessDefinitionRef> results = new ArrayList<ProcessDefinitionRef>();
        for (TProcessInfo pi : processInfoListDocument.getProcessInfoList().getProcessInfoList()) {
            QName processQName = pi.getDefinitionInfo().getProcessName();
            ProcessDefinitionRef def = new ProcessDefinitionRef(ModelAdaptor.encodeId(pi.getPid()), processQName.toString(), pi.getVersion());
            def.setPackageName(processQName.getNamespaceURI());
            def.setDeploymentId(pi.getDeploymentInfo().getPackage());
            def.setSuspended(pi.getStatus() == TProcessStatus.RETIRED);
            results.add(def);
        }
        return results;
    }

    public static List<ProcessInstanceRef> adoptInstances(QName procesQName, InstanceInfoListDocument instanceListDocument) {
        ArrayList<ProcessInstanceRef> results = new ArrayList<ProcessInstanceRef>();
        for (TInstanceInfo i0 : instanceListDocument.getInstanceInfoList().getInstanceInfoList()) {
            if (!i0.getPid().equals(procesQName.toString())) continue;
            ProcessInstanceRef ref = new ProcessInstanceRef(i0.getIid(), ModelAdaptor.encodeId(i0.getPid()), i0.getDtStarted().getTime(), null, false);
            results.add(ref);
        }
        return results;
    }

    public static String encodeId(String actualId) {
        return Base64.encodeBytes(actualId.getBytes());
    }

    public static String decodeId(String encodedId) {
        try {
            return new String(Base64.decode(encodedId));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decode id", e);
        }
    }
}

