/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.ScopeInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.CompensationHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.EventHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.FaultHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.TerminationHandlerImpl;

public class ScopeImpl
extends ActivityImpl
implements ScopeInterface {
    private SVGDimension coreDimensions = null;
    private SVGDimension conditionalDimensions = null;
    private int handlerIconWidth = 16;
    private int handlerIconHeight = 16;

    public ScopeImpl(String token) {
        super(token);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public ScopeImpl(OMElement omElement) {
        super(omElement);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public ScopeImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
    }

    public int getHandlerIconHeight() {
        return this.handlerIconHeight;
    }

    public int getHandlerIconWidth() {
        return this.handlerIconWidth;
    }

    public void setHandlerIconHeight(int handlerIconHeight) {
        this.handlerIconHeight = handlerIconHeight;
    }

    public void setHandlerIconWidth(int handlerIconWidth) {
        this.handlerIconWidth = handlerIconWidth;
    }

    protected int getHandlerConnectorSpacing() {
        int spacing = 5;
        return spacing;
    }

    protected int getHandlerAdjustment() {
        int adjustment = 0;
        adjustment = this.layoutManager.isVerticalLayout() ? this.getHandlerIconHeight() * 4 + this.getHandlerConnectorSpacing() * 4 : this.getHandlerIconWidth() * 4 + this.getHandlerConnectorSpacing() * 4;
        return adjustment;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getEndTag() {
        return "/scope";
    }

    @Override
    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            int coreWidth = 0;
            int coreHeight = 0;
            int conWidth = 0;
            int conHeight = 0;
            this.dimensions = new SVGDimension(coreWidth, coreHeight);
            this.coreDimensions = new SVGDimension(coreWidth, coreHeight);
            this.conditionalDimensions = new SVGDimension(conWidth, conHeight);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (activity2 instanceof FaultHandlerImpl || activity2 instanceof TerminationHandlerImpl || activity2 instanceof CompensationHandlerImpl || activity2 instanceof EventHandlerImpl) {
                    if (subActivityDim.getHeight() > conHeight) {
                        conHeight = subActivityDim.getHeight();
                    }
                    conWidth += subActivityDim.getWidth();
                    continue;
                }
                if (subActivityDim.getWidth() > coreWidth) {
                    coreWidth = subActivityDim.getWidth();
                }
                coreHeight += subActivityDim.getHeight();
            }
            coreHeight += this.getYSpacing() + this.getStartIconHeight() + this.getEndIconHeight();
            if (!this.isSimpleLayout()) {
                coreWidth += this.getXSpacing();
            }
            this.coreDimensions.setHeight(coreHeight);
            this.coreDimensions.setWidth(coreWidth);
            this.conditionalDimensions.setHeight(conHeight += this.getHandlerAdjustment());
            this.conditionalDimensions.setWidth(conWidth);
            height = coreHeight > conHeight ? coreHeight : conHeight;
            width = coreWidth + conWidth;
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing());
        }
        return this.dimensions;
    }

    public SVGDimension getCoreDimensions() {
        return this.coreDimensions;
    }

    public SVGDimension getConditionalDimensions() {
        return this.conditionalDimensions;
    }

    @Override
    public void switchDimensionsToHorizontal() {
        super.switchDimensionsToHorizontal();
        int height = 0;
        int width = 0;
        height = this.coreDimensions.getHeight();
        width = this.coreDimensions.getWidth();
        this.coreDimensions.setHeight(width);
        this.coreDimensions.setWidth(height);
        height = this.conditionalDimensions.getHeight();
        width = this.conditionalDimensions.getWidth();
        this.conditionalDimensions.setHeight(width);
        this.conditionalDimensions.setWidth(height);
    }

    private boolean isSimpleLayout() {
        boolean simple = true;
        ActivityInterface activity2 = null;
        for (ActivityInterface activity2 : this.getSubActivities()) {
            if (!(activity2 instanceof FaultHandlerImpl) && !(activity2 instanceof TerminationHandlerImpl) && !(activity2 instanceof CompensationHandlerImpl) && !(activity2 instanceof EventHandlerImpl)) continue;
            simple = false;
            break;
        }
        return simple;
    }

    @Override
    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.getDimensions().getWidth() / 2;
        int xLeft = 0;
        int yTop = 0;
        int endXLeft = 0;
        int endYTop = 0;
        int centerNHLayout = startXLeft + this.getCoreDimensions().getWidth() / 2;
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
        this.getCoreDimensions().setXLeft(startXLeft + this.getXSpacing() / 2);
        this.getCoreDimensions().setYTop(startYTop + this.getYSpacing() / 2);
        if (this.isSimpleLayout()) {
            xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
            yTop = startYTop + this.getYSpacing() / 2;
            endXLeft = centreOfMyLayout - this.getEndIconWidth() / 2;
            endYTop = startYTop + this.getDimensions().getHeight() - this.getEndIconHeight() - this.getYSpacing() / 2;
        } else {
            xLeft = centerNHLayout - this.getStartIconWidth() / 2 + this.getXSpacing() / 2;
            yTop = this.getCoreDimensions().getYTop() + this.getYSpacing() / 2;
            endXLeft = centerNHLayout - this.getEndIconWidth() / 2 + this.getXSpacing() / 2;
            endYTop = this.getCoreDimensions().getYTop() + this.getCoreDimensions().getHeight() - this.getEndIconHeight() - this.getYSpacing() / 2;
        }
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = 0;
        int childXLeft = 0;
        if (this.isSimpleLayout()) {
            childYTop = yTop + this.getStartIconHeight() + this.getYSpacing() / 2;
            childXLeft = startXLeft + this.getXSpacing() / 2;
        } else {
            childYTop = this.getCoreDimensions().getYTop() + this.getStartIconHeight() + this.getYSpacing() / 2;
            childXLeft = this.getCoreDimensions().getXLeft() + this.getXSpacing() / 2;
        }
        while (itr.hasNext()) {
            activity = itr.next();
            if (activity instanceof FaultHandlerImpl || activity instanceof TerminationHandlerImpl || activity instanceof CompensationHandlerImpl || activity instanceof EventHandlerImpl) continue;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        itr = this.getSubActivities().iterator();
        childXLeft = startXLeft + this.getCoreDimensions().getWidth();
        childYTop = yTop + this.getHandlerAdjustment();
        while (itr.hasNext()) {
            activity = itr.next();
            if (!(activity instanceof FaultHandlerImpl) && !(activity instanceof TerminationHandlerImpl) && !(activity instanceof CompensationHandlerImpl) && !(activity instanceof EventHandlerImpl)) continue;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
    }

    private void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = 0;
        int yTop = 0;
        int endXLeft = 0;
        int endYTop = 0;
        int centerNHLayout = startYTop + this.coreDimensions.getHeight() / 2;
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
        this.getCoreDimensions().setXLeft(startXLeft + this.getXSpacing() / 2);
        this.getCoreDimensions().setYTop(startYTop + this.getYSpacing() / 2);
        if (this.isSimpleLayout()) {
            yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
            xLeft = startXLeft + this.getYSpacing() / 2;
            endYTop = centreOfMyLayout - this.getEndIconHeight() / 2;
            endXLeft = this.getCoreDimensions().getXLeft() + this.getCoreDimensions().getWidth() - this.getEndIconWidth() - this.getXSpacing() / 2;
        } else {
            yTop = centerNHLayout - this.getStartIconHeight() / 2 + this.getYSpacing() / 2;
            xLeft = this.getCoreDimensions().getXLeft() + this.getXSpacing() / 2;
            endYTop = centerNHLayout - this.getEndIconHeight() / 2 + this.getYSpacing() / 2;
            endXLeft = this.getCoreDimensions().getXLeft() + this.getCoreDimensions().getWidth() - this.getEndIconWidth() - this.getXSpacing() / 2;
        }
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childXLeft = 0;
        int childYTop = 0;
        if (this.isSimpleLayout()) {
            childXLeft = xLeft + this.getStartIconWidth() + this.getYSpacing() / 2;
            childYTop = startYTop + this.getXSpacing() / 2;
        } else {
            childXLeft = this.getCoreDimensions().getXLeft() + this.getStartIconWidth() + this.getYSpacing() / 2;
            childYTop = this.getCoreDimensions().getYTop() + this.getXSpacing() / 2;
        }
        while (itr.hasNext()) {
            activity = itr.next();
            if (activity instanceof FaultHandlerImpl || activity instanceof TerminationHandlerImpl || activity instanceof CompensationHandlerImpl || activity instanceof EventHandlerImpl) continue;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        itr = this.getSubActivities().iterator();
        childYTop = startYTop + this.getCoreDimensions().getHeight() + this.getYSpacing() / 2;
        childXLeft = xLeft + this.getHandlerAdjustment();
        while (itr.hasNext()) {
            activity = itr.next();
            if (!(activity instanceof FaultHandlerImpl) && !(activity instanceof TerminationHandlerImpl) && !(activity instanceof CompensationHandlerImpl) && !(activity instanceof EventHandlerImpl)) continue;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
    }

    @Override
    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop();
        } else {
            xLeft = this.getStartIconXLeft();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    @Override
    public SVGCoordinates getExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop() + this.getEndIconHeight();
        } else {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartIconExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getEndIconEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop();
        } else {
            xLeft = this.getEndIconXLeft();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartEventCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getCoreDimensions().getXLeft() + this.getCoreDimensions().getWidth();
            yTop = this.getCoreDimensions().getYTop() + this.getHandlerConnectorSpacing() + this.getYSpacing() / 2;
        } else {
            xLeft = this.getCoreDimensions().getXLeft() + this.getHandlerConnectorSpacing() + this.getYSpacing() / 2;
            yTop = this.getCoreDimensions().getYTop() + this.getCoreDimensions().getHeight();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartTerminationCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getCoreDimensions().getXLeft() + this.getCoreDimensions().getWidth();
            yTop = this.getCoreDimensions().getYTop() + this.getHandlerIconHeight() + this.getHandlerConnectorSpacing() * 2 + this.getYSpacing() / 2;
        } else {
            xLeft = this.getCoreDimensions().getXLeft() + this.getHandlerIconWidth() + this.getHandlerConnectorSpacing() * 2 + this.getYSpacing() / 2;
            yTop = this.getCoreDimensions().getYTop() + this.getCoreDimensions().getHeight();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartCompensationCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getCoreDimensions().getXLeft() + this.getCoreDimensions().getWidth();
            yTop = this.getCoreDimensions().getYTop() + this.getHandlerIconHeight() * 2 + this.getHandlerConnectorSpacing() * 3 + this.getYSpacing() / 2;
        } else {
            xLeft = this.getCoreDimensions().getXLeft() + this.getHandlerIconWidth() * 2 + this.getHandlerConnectorSpacing() * 3 + this.getYSpacing() / 2;
            yTop = this.getCoreDimensions().getYTop() + this.getCoreDimensions().getHeight();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartFaultCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getCoreDimensions().getXLeft() + this.getCoreDimensions().getWidth();
            yTop = this.getCoreDimensions().getYTop() + this.getHandlerIconHeight() * 3 + this.getHandlerConnectorSpacing() * 4 + this.getYSpacing() / 2;
        } else {
            xLeft = this.getCoreDimensions().getXLeft() + this.getHandlerIconWidth() * 3 + this.getHandlerConnectorSpacing() * 4 + this.getYSpacing() / 2;
            yTop = this.getCoreDimensions().getYTop() + this.getCoreDimensions().getHeight();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    @Override
    public Element getSVGString(SVGDocument doc) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group.appendChild(this.getBoxDefinition(doc));
        group.appendChild(this.getImageDefinition(doc));
        if (!this.isSimpleLayout()) {
            group.appendChild(this.getEventHandlerIcon(doc));
            group.appendChild(this.getCompensationHandlerIcon(doc));
            group.appendChild(this.getFaultHandlerIcon(doc));
            group.appendChild(this.getTerminationHandlerIcon(doc));
        }
        group.appendChild(this.getSubActivitiesSVGString(doc));
        group.appendChild(this.getEndImageDefinition(doc));
        group.appendChild(this.getArrows(doc));
        return group;
    }

    protected Element getArrows(SVGDocument doc) {
        if (this.subActivities != null) {
            Element subGroup = doc.createElementNS("http://www.w3.org/2000/svg", "g");
            ActivityInterface prevActivity = null;
            ActivityInterface activity2 = null;
            String id = null;
            SVGCoordinates myStartCoords = this.getStartIconExitArrowCoords();
            SVGCoordinates myExitCoords = this.getEndIconEntryArrowCoords();
            SVGCoordinates myStartEventCoords = this.getStartEventCoords();
            SVGCoordinates myStartTerminationCoords = this.getStartTerminationCoords();
            SVGCoordinates myStartCompensationCoords = this.getStartCompensationCoords();
            SVGCoordinates myStartFaultCoords = this.getStartFaultCoords();
            SVGCoordinates activityEntryCoords = null;
            SVGCoordinates activityExitCoords = null;
            for (ActivityInterface activity2 : this.subActivities) {
                activityEntryCoords = activity2.getEntryArrowCoords();
                activityExitCoords = activity2.getExitArrowCoords();
                id = this.getId() + "-" + activity2.getId();
                if (activity2 instanceof FaultHandlerImpl) {
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartFaultCoords.getXLeft(), myStartFaultCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, activity2, activity2));
                } else if (activity2 instanceof TerminationHandlerImpl) {
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartTerminationCoords.getXLeft(), myStartTerminationCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, activity2, activity2));
                } else if (activity2 instanceof CompensationHandlerImpl) {
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartCompensationCoords.getXLeft(), myStartCompensationCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, activity2, activity2));
                } else if (activity2 instanceof EventHandlerImpl) {
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartEventCoords.getXLeft(), myStartEventCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, activity2, activity2));
                } else {
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartCoords.getXLeft(), myStartCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, activity2, activity2));
                    subGroup.appendChild(this.getArrowDefinition(doc, activityExitCoords.getXLeft(), activityExitCoords.getYTop(), myExitCoords.getXLeft(), myExitCoords.getYTop(), id, activity2, activity2));
                }
                prevActivity = activity2;
            }
            return subGroup;
        }
        return null;
    }

    @Override
    protected Element getBoxDefinition(SVGDocument doc) {
        if (this.isSimpleLayout()) {
            return super.getBoxDefinition(doc);
        }
        return this.getBoxDefinition(doc, this.getCoreDimensions().getXLeft() + 10, this.getCoreDimensions().getYTop() + 10, this.getCoreDimensions().getWidth() - 20, this.getCoreDimensions().getHeight() - 20, this.getBoxId());
    }

    @Override
    protected Element getStartImageText(SVGDocument doc) {
        if (this.isSimpleLayout()) {
            return this.getImageText(doc, this.getDimensions().getXLeft(), this.getDimensions().getYTop(), this.getStartIconWidth(), this.getStartIconHeight(), this.getStartImageTextId(), this.getDisplayName());
        }
        return this.getImageText(doc, this.getCoreDimensions().getXLeft(), this.getCoreDimensions().getYTop(), this.getStartIconWidth(), this.getStartIconHeight(), this.getStartImageTextId(), this.getDisplayName());
    }

    @Override
    public Element getTerminationHandlerIcon(SVGDocument doc) {
        SVGCoordinates coords = this.getStartTerminationCoords();
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth();
            yTop = coords.getYTop() - this.getHandlerIconHeight() / 2;
        } else {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth() / 2;
            yTop = coords.getYTop() - this.getHandlerIconHeight();
        }
        String iconPath = BPEL2SVGFactory.getInstance().getIconSource() + "/scopeterminationhandler" + BPEL2SVGFactory.getInstance().getIconExtension();
        return this.getImageDefinition(doc, iconPath, xLeft, yTop, this.getHandlerIconWidth(), this.getHandlerIconHeight(), this.getId());
    }

    @Override
    public Element getFaultHandlerIcon(SVGDocument doc) {
        SVGCoordinates coords = this.getStartFaultCoords();
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth();
            yTop = coords.getYTop() - this.getHandlerIconHeight() / 2;
        } else {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth() / 2;
            yTop = coords.getYTop() - this.getHandlerIconHeight();
        }
        String iconPath = BPEL2SVGFactory.getInstance().getIconSource() + "/scopefaulthandler" + BPEL2SVGFactory.getInstance().getIconExtension();
        return this.getImageDefinition(doc, iconPath, xLeft, yTop, this.getHandlerIconWidth(), this.getHandlerIconHeight(), this.getId());
    }

    @Override
    public Element getCompensationHandlerIcon(SVGDocument doc) {
        SVGCoordinates coords = this.getStartCompensationCoords();
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth();
            yTop = coords.getYTop() - this.getHandlerIconHeight() / 2;
        } else {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth() / 2;
            yTop = coords.getYTop() - this.getHandlerIconHeight();
        }
        String iconPath = BPEL2SVGFactory.getInstance().getIconSource() + "/scopecompensationhandler" + BPEL2SVGFactory.getInstance().getIconExtension();
        return this.getImageDefinition(doc, iconPath, xLeft, yTop, this.getHandlerIconWidth(), this.getHandlerIconHeight(), this.getId());
    }

    @Override
    public Element getEventHandlerIcon(SVGDocument doc) {
        SVGCoordinates coords = this.getStartEventCoords();
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth();
            yTop = coords.getYTop() - this.getHandlerIconHeight() / 2;
        } else {
            xLeft = coords.getXLeft() - this.getHandlerIconWidth() / 2;
            yTop = coords.getYTop() - this.getHandlerIconHeight();
        }
        String iconPath = BPEL2SVGFactory.getInstance().getIconSource() + "/scopeeventhandler" + BPEL2SVGFactory.getInstance().getIconExtension();
        return this.getImageDefinition(doc, iconPath, xLeft, yTop, this.getHandlerIconWidth(), this.getHandlerIconHeight(), this.getId());
    }

    @Override
    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    @Override
    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

